/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.domain;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.compute.Address;
import org.openstack4j.model.compute.Addresses;

public class NovaAddresses
implements Addresses {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="addresses")
    private Map<String, List<NovaAddress>> addresses = Maps.newHashMap();

    @Override
    public void add(String key, Address value) {
        if (!this.addresses.containsKey(key)) {
            this.addresses.put(key, Lists.newArrayList());
        }
        this.addresses.get(key).add((NovaAddress)value);
    }

    @JsonAnySetter
    public void add(String key, List<NovaAddress> value) {
        this.addresses.put(key, value);
    }

    @Override
    public Map<String, List<? extends Address>> getAddresses() {
        return (Map)this.encapsulate();
    }

    @Override
    public List<? extends Address> getAddresses(String type) {
        return this.addresses.get(type);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("addresses", this.addresses).addValue((Object)"\n").toString();
    }

    private <T> T encapsulate() {
        return (T)this.addresses;
    }

    public static class NovaAddress
    implements Address {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="OS-EXT-IPS-MAC:mac_addr")
        private String macAddr;
        private int version;
        private String addr;
        @JsonProperty(value="OS-EXT-IPS:type")
        private String type;

        @Override
        public String getMacAddr() {
            return this.macAddr;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public String getAddr() {
            return this.addr;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("address", (Object)this.addr).add("type", (Object)this.type).add("version", this.version).add("macaddr", (Object)this.macAddr).addValue((Object)"\n").toString();
        }
    }
}

