/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.Apis;
import org.openstack4j.model.common.Link;
import org.openstack4j.model.common.functions.IdEntityToString;
import org.openstack4j.model.compute.Addresses;
import org.openstack4j.model.compute.Fault;
import org.openstack4j.model.compute.Flavor;
import org.openstack4j.model.compute.Image;
import org.openstack4j.model.compute.Server;
import org.openstack4j.openstack.common.GenericLink;
import org.openstack4j.openstack.common.IdResourceEntity;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.compute.domain.NovaAddresses;
import org.openstack4j.openstack.compute.domain.NovaFault;
import org.openstack4j.openstack.compute.domain.NovaFlavor;
import org.openstack4j.openstack.compute.domain.NovaImage;
import org.openstack4j.openstack.compute.domain.NovaSecurityGroup;

@JsonRootName(value="server")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NovaServer
implements Server {
    public static final long serialVersionUID = 1L;
    public String id;
    public String name;
    public NovaAddresses addresses;
    public List<GenericLink> links;
    public Object image;
    public NovaFlavor flavor;
    public String accessIPv4;
    public String accessIPv6;
    @JsonProperty(value="config_drive")
    public String configDrive;
    public Server.Status status;
    public Integer progress;
    public NovaFault fault;
    @JsonProperty(value="tenant_id")
    public String tenantId;
    @JsonProperty(value="user_id")
    public String userId;
    @JsonProperty(value="key_name")
    public String keyName;
    public String hostId;
    public Date updated;
    public Date created;
    public Map<String, String> metadata;
    @JsonProperty(value="security_groups")
    private List<NovaSecurityGroup> securityGroups;
    @JsonProperty(value="OS-EXT-STS:task_state")
    private String taskState;
    @JsonProperty(value="OS-EXT-STS:power_state")
    private String powerState;
    @JsonProperty(value="OS-EXT-STS:vm_state")
    private String vmState;
    @JsonProperty(value="OS-EXT-SRV-ATTR:host")
    private String host;
    @JsonProperty(value="OS-EXT-SRV-ATTR:instance_name")
    private String instanceName;
    @JsonProperty(value="OS-EXT-SRV-ATTR:hypervisor_hostname")
    private String hypervisorHostname;
    @JsonProperty(value="OS-DCF:diskConfig")
    private Server.DiskConfig diskConfig;
    @JsonProperty(value="OS-EXT-AZ:availability_zone")
    private String availabilityZone;
    @JsonProperty(value="OS-SRV-USG:launched_at")
    private Date launchedAt;
    @JsonProperty(value="OS-SRV-USG:terminated_at")
    private Date terminatedAt;
    @JsonProperty(value="os-extended-volumes:volumes_attached")
    private List<IdResourceEntity> osExtendedVolumesAttached;
    private String uuid;
    private String adminPass;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Addresses getAddresses() {
        return this.addresses;
    }

    @Override
    public List<? extends Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonIgnore
    public String getImageId() {
        if (this.image instanceof Map) {
            Map map = (Map)this.image;
            return (String)map.get("id");
        }
        return null;
    }

    @Override
    public Image getImage() {
        if (this.image instanceof LinkedHashMap) {
            LinkedHashMap map = (LinkedHashMap)this.image;
            String imageId = (String)map.get("id");
            if (imageId == null || imageId.isEmpty()) {
                return null;
            }
            NovaImage novaImage = (NovaImage)Apis.getComputeServices().images().get(imageId);
            return novaImage;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getFlavorId() {
        return this.flavor != null ? this.flavor.getId() : null;
    }

    @Override
    public Flavor getFlavor() {
        if (this.flavor != null && this.flavor.getName() == null) {
            this.flavor = (NovaFlavor)Apis.getComputeServices().flavors().get(this.flavor.getId());
        }
        return this.flavor;
    }

    @Override
    public String getAccessIPv4() {
        return this.accessIPv4;
    }

    @Override
    public String getAccessIPv6() {
        return this.accessIPv6;
    }

    @Override
    public String getConfigDrive() {
        return this.configDrive;
    }

    @Override
    public Server.Status getStatus() {
        return this.status;
    }

    @Override
    public int getProgress() {
        return this.progress != null ? this.progress : 0;
    }

    @Override
    public Fault getFault() {
        return this.fault;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public String getHostId() {
        return this.hostId;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public List<? extends NovaSecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public String getTaskState() {
        return this.taskState;
    }

    @Override
    public String getPowerState() {
        return this.powerState;
    }

    @Override
    public String getVmState() {
        return this.vmState;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public String getHypervisorHostname() {
        return this.hypervisorHostname;
    }

    @Override
    public Server.DiskConfig getDiskConfig() {
        return this.diskConfig;
    }

    @Override
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    @Override
    public Date getLaunchedAt() {
        return this.launchedAt;
    }

    @Override
    public Date getTerminatedAt() {
        return this.terminatedAt;
    }

    @Override
    @JsonIgnore
    public List<String> getOsExtendedVolumesAttached() {
        return this.osExtendedVolumesAttached == null ? Collections.emptyList() : Lists.transform(this.osExtendedVolumesAttached, (Function)IdEntityToString.INSTANCE);
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getAdminPass() {
        return this.adminPass;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("image", this.image).add("flavor", (Object)this.flavor).add("status", (Object)this.status).add("diskconfig", (Object)this.diskConfig).add("userId", (Object)this.userId).add("admin-pass", (Object)this.adminPass).add("created", (Object)this.created).add("updated", (Object)this.updated).add("launched at", (Object)this.launchedAt).add("tenantId", (Object)this.tenantId).add("hostId", (Object)this.hostId).add("addresses", (Object)this.addresses).add("hypervisor host", (Object)this.hypervisorHostname).add("uuid", (Object)this.uuid).add("powerstate", (Object)this.powerState).add("fault", (Object)this.fault).add("instanceName", (Object)this.instanceName).add("vmState", (Object)this.vmState).add("metadata", this.metadata).toString();
    }

    public static class Servers
    extends ListResult<NovaServer> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="servers")
        private List<NovaServer> servers;

        @Override
        public List<NovaServer> value() {
            return this.servers;
        }
    }
}

