/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.dns.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.dns.v2.Action;
import org.openstack4j.model.dns.v2.Status;
import org.openstack4j.model.dns.v2.Zone;
import org.openstack4j.model.dns.v2.ZoneType;
import org.openstack4j.model.dns.v2.builder.ZoneBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DesignateZone
implements Zone {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="pool_id")
    private String poolId;
    @JsonProperty(value="project_id")
    private String projectId;
    private String name;
    private String email;
    private Integer ttl;
    private String serial;
    private Status status;
    private Action action;
    private String description;
    private List<String> masters;
    private ZoneType type;
    @JsonProperty(value="tranferred_at")
    private String transferredAt;
    private Integer version;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="updated_at")
    private String updatedAt;
    private Map<String, String> links;

    public static ZoneBuilder builder() {
        return new ZoneConcreteBuilder();
    }

    @Override
    public ZoneBuilder toBuilder() {
        return new ZoneConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPoolId() {
        return this.poolId;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Integer getTTL() {
        return this.ttl;
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getMasters() {
        return this.masters;
    }

    @Override
    public ZoneType getType() {
        return this.type;
    }

    @Override
    public String getTransferedAt() {
        return this.transferredAt;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("poolId", (Object)this.poolId).add("projectId", (Object)this.projectId).add("name", (Object)this.name).add("email", (Object)this.email).add("ttl", (Object)this.ttl).add("serial", (Object)this.serial).add("status", (Object)this.status).add("action", (Object)this.action).add("description", (Object)this.description).add("masters", this.masters).add("type", (Object)this.type).add("transferredAt", (Object)this.transferredAt).add("version", (Object)this.version).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).add("links", this.links).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.poolId, this.projectId, this.name, this.email, this.ttl, this.serial, this.status, this.action, this.description, this.masters, this.type, this.transferredAt, this.version, this.createdAt, this.updatedAt});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DesignateZone that = (DesignateZone)DesignateZone.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.poolId, (Object)that.poolId) && Objects.equal((Object)this.projectId, (Object)that.projectId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.email, (Object)that.email) && Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal((Object)this.serial, (Object)that.serial) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)((Object)this.action), (Object)((Object)that.action)) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.masters, that.masters) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.transferredAt, (Object)that.transferredAt) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.createdAt, (Object)that.createdAt) && Objects.equal((Object)this.updatedAt, (Object)that.updatedAt) && Objects.equal(this.links, that.links);
    }

    public static class Zones
    extends ListResult<DesignateZone> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="zones")
        protected List<DesignateZone> list;

        @Override
        public List<DesignateZone> value() {
            return this.list;
        }
    }

    public static class ZoneConcreteBuilder
    implements ZoneBuilder {
        DesignateZone model;

        ZoneConcreteBuilder() {
            this(new DesignateZone());
        }

        ZoneConcreteBuilder(DesignateZone model) {
            this.model = model;
        }

        @Override
        public Zone build() {
            return this.model;
        }

        @Override
        public ZoneBuilder from(Zone in) {
            if (in != null) {
                this.model = (DesignateZone)in;
            }
            return this;
        }

        @Override
        public ZoneBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public ZoneBuilder poolId(String poolId) {
            this.model.poolId = poolId;
            return this;
        }

        @Override
        public ZoneBuilder projectId(String projectId) {
            this.model.projectId = projectId;
            return this;
        }

        @Override
        public ZoneBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public ZoneBuilder email(String email) {
            this.model.email = email;
            return this;
        }

        @Override
        public ZoneBuilder ttl(Integer ttl) {
            this.model.ttl = ttl;
            return this;
        }

        @Override
        public ZoneBuilder serial(String serial) {
            this.model.serial = serial;
            return this;
        }

        @Override
        public ZoneBuilder status(Status status) {
            this.model.status = status;
            return this;
        }

        @Override
        public ZoneBuilder action(Action action) {
            this.model.action = action;
            return this;
        }

        @Override
        public ZoneBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public ZoneBuilder masters(List<String> masters) {
            this.model.masters = masters;
            return this;
        }

        @Override
        public ZoneBuilder type(ZoneType type) {
            this.model.type = type;
            return this;
        }

        @Override
        public ZoneBuilder transferredAt(String transferredAt) {
            this.model.transferredAt = transferredAt;
            return this;
        }

        @Override
        public ZoneBuilder version(Integer version) {
            this.model.version = version;
            return this;
        }

        @Override
        public ZoneBuilder createdAt(String createdAt) {
            this.model.createdAt = createdAt;
            return this;
        }

        @Override
        public ZoneBuilder updatedAt(String updatedAt) {
            this.model.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ZoneBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }
    }
}

