/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.internal;

import com.google.common.base.Optional;
import com.google.common.collect.SortedSetMultimap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import org.openstack4j.api.exceptions.RegionEndpointNotFoundException;
import org.openstack4j.api.identity.EndpointURLResolver;
import org.openstack4j.api.types.Facing;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.model.identity.URLResolverParams;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.model.identity.v2.builder.EndpointBuilder;
import org.openstack4j.model.identity.v3.Endpoint;
import org.openstack4j.model.identity.v3.Service;
import org.openstack4j.model.identity.v3.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointURLResolver
implements EndpointURLResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEndpointURLResolver.class);
    private static final Map<Key, String> CACHE = new ConcurrentHashMap<Key, String>();
    private static boolean LEGACY_EP_HANDLING = Boolean.getBoolean("legacy.endpoint.resolving.enabled");
    private String publicHostIP;

    @Override
    public String findURLV2(URLResolverParams p) {
        if (p.type == null) {
            return p.access.getEndpoint();
        }
        Key key = Key.of(p.access.getCacheIdentifier(), p.type, p.perspective, p.region);
        String url = CACHE.get(key);
        if (url != null) {
            return url;
        }
        url = this.resolveV2(p);
        if (url != null) {
            return url;
        }
        if (p.region != null) {
            throw RegionEndpointNotFoundException.create(p.region, p.type.getServiceName());
        }
        return p.access.getEndpoint();
    }

    @Override
    public String findURLV3(URLResolverParams p) {
        if (p.type == null) {
            return p.token.getEndpoint();
        }
        Key key = Key.of(p.token.getCacheIdentifier(), p.type, p.perspective, p.region);
        String url = CACHE.get(key);
        if (url != null) {
            return url;
        }
        url = this.resolveV3(p);
        if (url != null) {
            CACHE.put(key, url);
            return url;
        }
        if (p.region != null) {
            throw RegionEndpointNotFoundException.create(p.region, p.type.getServiceName());
        }
        return p.token.getEndpoint();
    }

    private String resolveV2(URLResolverParams p) {
        SortedSetMultimap<String, ? extends Access.Service> catalog = p.access.getAggregatedCatalog();
        SortedSet services = catalog.get((Object)p.type.getServiceName());
        if (services.isEmpty()) {
            services = catalog.get((Object)p.type.getType());
        }
        if (!services.isEmpty()) {
            Access.Service sc = p.getV2Resolver().resolveV2(p.type, services);
            for (org.openstack4j.model.identity.v2.Endpoint endpoint : sc.getEndpoints()) {
                if (p.region != null && !p.region.equalsIgnoreCase(endpoint.getRegion())) continue;
                if (sc.getServiceType() == ServiceType.NETWORK) {
                    ((EndpointBuilder)sc.getEndpoints().get(0).toBuilder()).type(sc.getServiceType().name());
                }
                if (p.perspective == null) {
                    return this.getEndpointURL(p.access, endpoint);
                }
                switch (p.perspective) {
                    case ADMIN: {
                        return endpoint.getAdminURL().toString();
                    }
                    case INTERNAL: {
                        return endpoint.getInternalURL().toString();
                    }
                }
                return endpoint.getPublicURL().toString();
            }
        } else if (ServiceType.IDENTITY.equals((Object)p.type)) {
            return p.access.getEndpoint();
        }
        return null;
    }

    private String resolveV3(URLResolverParams p) {
        Token token = p.token;
        if (token.getCatalog() == null) {
            if (ServiceType.IDENTITY.equals((Object)p.type)) {
                return token.getEndpoint();
            }
            return null;
        }
        for (Service service : token.getCatalog()) {
            if (p.type != ServiceType.forName(service.getType())) continue;
            if (p.perspective == null) {
                p.perspective = Facing.PUBLIC;
            }
            for (Endpoint endpoint : service.getEndpoints()) {
                if (!this.matches(endpoint, p)) continue;
                return endpoint.getUrl().toString();
            }
        }
        return null;
    }

    private boolean matches(Endpoint endpoint, URLResolverParams p) {
        boolean matches;
        boolean bl = matches = endpoint.getIface() == p.perspective;
        if (Optional.fromNullable((Object)p.region).isPresent()) {
            matches &= endpoint.getRegion().equals(p.region);
        }
        return matches;
    }

    private String getEndpointURL(Access access, org.openstack4j.model.identity.v2.Endpoint endpoint) {
        if (LEGACY_EP_HANDLING && endpoint.getAdminURL() != null) {
            if (this.getPublicIP(access) != null && !this.getPublicIP(access).equals(endpoint.getAdminURL().getHost())) {
                return endpoint.getAdminURL().toString().replaceAll(endpoint.getAdminURL().getHost(), this.getPublicIP(access));
            }
            return endpoint.getAdminURL().toString();
        }
        return endpoint.getPublicURL().toString();
    }

    private String getPublicIP(Access access) {
        if (this.publicHostIP == null) {
            try {
                this.publicHostIP = new URI(access.getEndpoint()).getHost();
            }
            catch (URISyntaxException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.publicHostIP;
    }

    private static final class Key {
        private final String uid;
        private final ServiceType type;
        private final Facing perspective;

        private Key(String uid, ServiceType type, Facing perspective) {
            this.type = type;
            this.perspective = perspective;
            this.uid = uid;
        }

        static Key of(String uid, ServiceType type, Facing perspective, String region) {
            return new Key(region == null ? uid : uid + region, type, perspective);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.perspective == null ? 0 : this.perspective.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.perspective != other.perspective) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
        }
    }
}

