/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.manila.SharesService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.manila.Access;
import org.openstack4j.model.manila.Share;
import org.openstack4j.model.manila.ShareCreate;
import org.openstack4j.model.manila.ShareUpdateOptions;
import org.openstack4j.model.manila.actions.AccessOptions;
import org.openstack4j.model.manila.builder.ShareCreateBuilder;
import org.openstack4j.openstack.common.Metadata;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.manila.domain.ManilaAccess;
import org.openstack4j.openstack.manila.domain.ManilaShare;
import org.openstack4j.openstack.manila.domain.ManilaShareCreate;
import org.openstack4j.openstack.manila.domain.ManilaShareUpdate;
import org.openstack4j.openstack.manila.domain.actions.ShareAction;
import org.openstack4j.openstack.manila.domain.actions.ShareActions;
import org.openstack4j.openstack.manila.internal.BaseShareServices;

public class SharesServiceImpl
extends BaseShareServices
implements SharesService {
    @Override
    public Share create(ShareCreate shareCreate) {
        Preconditions.checkNotNull((Object)shareCreate);
        return this.post(ManilaShare.class, this.uri("/shares", new Object[0])).entity(shareCreate).execute();
    }

    @Override
    public List<? extends Share> list() {
        return this.list(false);
    }

    @Override
    public List<? extends Share> listDetails() {
        return this.list(true);
    }

    private List<? extends Share> list(boolean detail) {
        return this.get(ManilaShare.Shares.class, this.uri("/shares" + (detail ? "/detail" : ""), new Object[0])).execute().getList();
    }

    @Override
    public Share get(String shareId) {
        Preconditions.checkNotNull((Object)shareId);
        return this.get(ManilaShare.class, this.uri("/shares/%s", shareId)).execute();
    }

    @Override
    public Share update(String shareId, ShareUpdateOptions shareUpdateOptions) {
        Preconditions.checkNotNull((Object)shareId);
        Preconditions.checkNotNull((Object)shareUpdateOptions);
        return this.put(ManilaShare.class, this.uri("/shares/%s", shareId)).entity(ManilaShareUpdate.fromOptions(shareUpdateOptions)).execute();
    }

    @Override
    public ActionResponse delete(String shareId) {
        Preconditions.checkNotNull((Object)shareId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/shares/%s", shareId)).executeWithResponse());
    }

    @Override
    public ActionResponse delete(String shareId, String consistencyGroupId) {
        Preconditions.checkNotNull((Object)shareId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/shares/%s", shareId)).param(consistencyGroupId != null, "consistency_group_id ", consistencyGroupId).executeWithResponse());
    }

    @Override
    public Metadata getMetadata(String shareId) {
        Preconditions.checkNotNull((Object)shareId);
        return this.get(Metadata.class, this.uri("/shares/%s/metadata", shareId)).execute();
    }

    @Override
    public Metadata updateMetadata(String shareId, Metadata metadata) {
        Preconditions.checkNotNull((Object)shareId);
        Preconditions.checkNotNull((Object)metadata);
        return this.put(Metadata.class, this.uri("/shares/%s/metadata", shareId)).entity(metadata).execute();
    }

    @Override
    public Metadata setMetadata(String shareId, Metadata metadata) {
        Preconditions.checkNotNull((Object)shareId);
        Preconditions.checkNotNull((Object)metadata);
        return this.post(Metadata.class, this.uri("/shares/%s/metadata/", shareId)).entity(metadata).execute();
    }

    @Override
    public ActionResponse unsetMetadata(String shareId, String metadataKey) {
        Preconditions.checkNotNull((Object)shareId);
        Preconditions.checkNotNull((Object)metadataKey);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/shares/%s/metadata/%s", shareId, metadataKey)).executeWithResponse());
    }

    @Override
    public Access grantAccess(String shareId, AccessOptions options) {
        Preconditions.checkNotNull((Object)shareId);
        Preconditions.checkNotNull((Object)options);
        return this.invokeAction(ManilaAccess.class, shareId, ShareActions.grantAccess(options));
    }

    @Override
    public ActionResponse revokeAccess(String shareId, String accessId) {
        Preconditions.checkNotNull((Object)shareId);
        Preconditions.checkNotNull((Object)accessId);
        return this.invokeAction(shareId, ShareActions.revokeAccess(accessId));
    }

    @Override
    public List<? extends Access> listAccess(String shareId) {
        Preconditions.checkNotNull((Object)shareId);
        return this.invokeAction(ManilaAccess.AccessList.class, shareId, ShareActions.listAccessRules()).getList();
    }

    @Override
    public ActionResponse resetState(String shareId, Share.Status status) {
        Preconditions.checkNotNull((Object)shareId);
        Preconditions.checkNotNull((Object)((Object)status));
        return this.invokeAction(shareId, ShareActions.resetState(status));
    }

    @Override
    public ActionResponse forceDelete(String shareId) {
        Preconditions.checkNotNull((Object)shareId);
        return this.invokeAction(shareId, ShareActions.forceDelete());
    }

    @Override
    public ActionResponse extend(String shareId, int newSize) {
        Preconditions.checkNotNull((Object)shareId);
        return this.invokeAction(shareId, ShareActions.extend(newSize));
    }

    @Override
    public ActionResponse shrink(String shareId, int newSize) {
        Preconditions.checkNotNull((Object)shareId);
        return this.invokeAction(shareId, ShareActions.shrink(newSize));
    }

    private <R> R invokeAction(Class<R> returnType, String shareId, ShareAction action) {
        return this.post(returnType, this.uri("/shares/%s/action", shareId)).entity(action).execute();
    }

    private ActionResponse invokeAction(String shareId, ShareAction action) {
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/shares/%s/action", shareId)).entity(action).executeWithResponse());
    }

    @Override
    public ShareCreateBuilder shareCreateBuilder() {
        return ManilaShareCreate.builder();
    }
}

