/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.List;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.network.builder.NetFloatingIPBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="floatingip")
public class NeutronFloatingIP
implements NetFloatingIP {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="router_id")
    private String routerId;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="floating_network_id")
    private String floatingNetworkId;
    @JsonProperty(value="floating_ip_address")
    private String floatingIpAddress;
    @JsonProperty(value="fixed_ip_address")
    private String fixedIpAddress;
    @JsonProperty(value="port_id")
    private String portId;
    private String status;

    @Override
    public NetFloatingIPBuilder toBuilder() {
        return new FloatingIPConcreteBuilder(this);
    }

    public static NetFloatingIPBuilder builder() {
        return new FloatingIPConcreteBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRouterId() {
        return this.routerId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getFloatingNetworkId() {
        return this.floatingNetworkId;
    }

    @Override
    public String getFloatingIpAddress() {
        return this.floatingIpAddress;
    }

    @Override
    public String getFixedIpAddress() {
        return this.fixedIpAddress;
    }

    @Override
    public String getPortId() {
        return this.portId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRouterId(String routerId) {
        this.routerId = routerId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setFloatingNetworkId(String floatingNetworkId) {
        this.floatingNetworkId = floatingNetworkId;
    }

    public void setFloatingIpAddress(String floatingIpAddress) {
        this.floatingIpAddress = floatingIpAddress;
    }

    public void setFixedIpAddress(String fixedIpAddress) {
        this.fixedIpAddress = fixedIpAddress;
    }

    public void setPortId(String portId) {
        this.portId = portId;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("routerId", (Object)this.routerId).add("tenantId", (Object)this.tenantId).add("floatingNetworkId", (Object)this.floatingNetworkId).add("floatingIpAddress", (Object)this.floatingIpAddress).add("fixedIpAddress", (Object)this.fixedIpAddress).add("portId", (Object)this.portId).add("status", (Object)this.status).addValue((Object)"\n").toString();
    }

    public static class FloatingIPConcreteBuilder
    implements NetFloatingIPBuilder {
        private NeutronFloatingIP f = null;

        public FloatingIPConcreteBuilder() {
            this.f = new NeutronFloatingIP();
        }

        public FloatingIPConcreteBuilder(NetFloatingIP in) {
            this.f = (NeutronFloatingIP)in;
        }

        @Override
        public NetFloatingIP build() {
            return this.f;
        }

        @Override
        public NetFloatingIPBuilder from(NetFloatingIP in) {
            this.f = (NeutronFloatingIP)in;
            return this;
        }

        @Override
        public NetFloatingIPBuilder floatingNetworkId(String networkId) {
            this.f.floatingNetworkId = networkId;
            return this;
        }

        @Override
        public NetFloatingIPBuilder portId(String portId) {
            this.f.portId = portId;
            return this;
        }
    }

    public static class FloatingIPs
    extends ListResult<NeutronFloatingIP> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="floatingips")
        private List<NeutronFloatingIP> floatingIps;

        @Override
        protected List<NeutronFloatingIP> value() {
            return this.floatingIps;
        }
    }
}

