/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import org.openstack4j.model.network.SecurityGroupUpdate;
import org.openstack4j.model.network.builder.NetSecurityGroupUpdateBuilder;

@JsonRootName(value="security_group")
public class NeutronSecurityGroupUpdate
implements SecurityGroupUpdate {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="security_group_id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;

    public static NetSecurityGroupUpdateBuilder builder() {
        return new NetSecurityGroupUpdateConcreteBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("description", (Object)this.description).add("id", (Object)this.id).toString();
    }

    @Override
    public NetSecurityGroupUpdateBuilder toBuilder() {
        return new NetSecurityGroupUpdateConcreteBuilder(this);
    }

    public static class NetSecurityGroupUpdateConcreteBuilder
    implements NetSecurityGroupUpdateBuilder {
        private NeutronSecurityGroupUpdate model;

        public NetSecurityGroupUpdateConcreteBuilder() {
            this.model = new NeutronSecurityGroupUpdate();
        }

        public NetSecurityGroupUpdateConcreteBuilder(NeutronSecurityGroupUpdate model) {
            this.model = model;
        }

        @Override
        public NeutronSecurityGroupUpdate build() {
            return this.model;
        }

        @Override
        public NetSecurityGroupUpdateBuilder from(SecurityGroupUpdate in) {
            this.model = (NeutronSecurityGroupUpdate)in;
            return this;
        }

        @Override
        public NetSecurityGroupUpdateBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public NetSecurityGroupUpdateBuilder description(String description) {
            this.model.description = description;
            return this;
        }
    }
}

