/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.sahara.ClusterTemplate;
import org.openstack4j.model.sahara.NodeGroup;
import org.openstack4j.model.sahara.ServiceConfig;
import org.openstack4j.model.sahara.builder.ClusterTemplateBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.sahara.domain.SaharaNodeGroup;
import org.openstack4j.openstack.sahara.domain.SaharaServiceConfig;

@JsonRootName(value="cluster_template")
public class SaharaClusterTemplate
implements ClusterTemplate {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="hadoop_version")
    private String hadoopVersion;
    @JsonProperty(value="default_image_id")
    private String defaultImageId;
    private String name;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="plugin_name")
    private String pluginName;
    @JsonProperty(value="anti_affinity")
    private List<String> antiAffinity;
    private String description;
    private String id;
    @JsonProperty(value="node_groups")
    private List<SaharaNodeGroup> nodeGroups;
    @JsonProperty(value="neutron_management_network")
    private String managementNetworkId;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="cluster_configs")
    private Map<String, SaharaServiceConfig> clusterConfigs;

    @Override
    public ClusterTemplateBuilder toBuilder() {
        return new ConcreteClusterTemplateBuilder(this);
    }

    public static ClusterTemplateBuilder builder() {
        return new ConcreteClusterTemplateBuilder();
    }

    @Override
    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    @Override
    public String getDefaultImageId() {
        return this.defaultImageId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public List<String> getAntiAffinity() {
        return this.antiAffinity;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<? extends NodeGroup> getNodeGroups() {
        return this.nodeGroups;
    }

    @Override
    public String getManagementNetworkId() {
        return this.managementNetworkId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Map<String, ? extends ServiceConfig> getClusterConfigs() {
        return this.clusterConfigs;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("hadoop_version", (Object)this.hadoopVersion).add("tenant_id", (Object)this.tenantId).add("created_at", (Object)this.createdAt).add("updated_at", (Object)this.updatedAt).add("plugin_name", (Object)this.pluginName).add("default_image_id", (Object)this.defaultImageId).add("anti_affinity", this.antiAffinity).add("neutron_management_network_id", (Object)this.managementNetworkId).add("node_groups", this.nodeGroups).add("cluster_configs", this.clusterConfigs).toString();
    }

    public static class ConcreteClusterTemplateBuilder
    implements ClusterTemplateBuilder {
        private SaharaClusterTemplate m;

        ConcreteClusterTemplateBuilder() {
            this(new SaharaClusterTemplate());
        }

        ConcreteClusterTemplateBuilder(SaharaClusterTemplate m) {
            this.m = m;
        }

        @Override
        public ClusterTemplate build() {
            return this.m;
        }

        @Override
        public ClusterTemplateBuilder from(ClusterTemplate in) {
            this.m = (SaharaClusterTemplate)in;
            return this;
        }

        @Override
        public ClusterTemplateBuilder pluginName(String pluginName) {
            this.m.pluginName = pluginName;
            return this;
        }

        @Override
        public ClusterTemplateBuilder hadoopVersion(String hadoopVersion) {
            this.m.hadoopVersion = hadoopVersion;
            return this;
        }

        @Override
        public ClusterTemplateBuilder addNodeGroup(NodeGroup nodeGroup) {
            if (this.m.nodeGroups == null) {
                this.m.nodeGroups = Lists.newArrayList();
            }
            this.m.nodeGroups.add((SaharaNodeGroup)nodeGroup);
            return this;
        }

        @Override
        public ClusterTemplateBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public ClusterTemplateBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public ClusterTemplateBuilder managementNetworkId(String networkId) {
            this.m.managementNetworkId = networkId;
            return this;
        }

        @Override
        public ClusterTemplateBuilder addServiceConfig(String name, ServiceConfig config) {
            if (name != null && !name.isEmpty()) {
                if (this.m.clusterConfigs == null) {
                    this.m.clusterConfigs = new HashMap();
                }
                this.m.clusterConfigs.put(name, (SaharaServiceConfig)config);
            }
            return this;
        }
    }

    public static class ClusterTemplates
    extends ListResult<SaharaClusterTemplate> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="cluster_templates")
        private List<SaharaClusterTemplate> nodeGroupTemplates;

        @Override
        protected List<SaharaClusterTemplate> value() {
            return this.nodeGroupTemplates;
        }
    }
}

