/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.sahara.DataSource;
import org.openstack4j.model.sahara.DataSourceCredentials;
import org.openstack4j.model.sahara.builder.DataSourceBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.sahara.domain.SaharaDataSourceCredentials;

@JsonRootName(value="data_source")
@JsonIgnoreProperties(ignoreUnknown=true)
public class SaharaDataSource
implements DataSource {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    private SaharaDataSourceCredentials credentials;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataSourceCredentials getCredentials() {
        return this.credentials;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("description", (Object)this.description).add("url", (Object)this.url).add("tenant_id", (Object)this.tenantId).add("created_at", (Object)this.createdAt).add("updated_at", (Object)this.updatedAt).add("type", (Object)this.type).add("id", (Object)this.id).add("name", (Object)this.name).toString();
    }

    @Override
    public DataSourceBuilder toBuilder() {
        return new ConcreteDataSourceBuilder(this);
    }

    public static DataSourceBuilder builder() {
        return new ConcreteDataSourceBuilder();
    }

    public static class ConcreteDataSourceBuilder
    implements DataSourceBuilder {
        SaharaDataSource m;

        ConcreteDataSourceBuilder() {
            this(new SaharaDataSource());
        }

        ConcreteDataSourceBuilder(SaharaDataSource m) {
            this.m = m;
        }

        @Override
        public DataSourceBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public DataSourceBuilder url(String url) {
            this.m.url = url;
            return this;
        }

        @Override
        public DataSourceBuilder type(String type) {
            this.m.type = type;
            return this;
        }

        @Override
        public DataSourceBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public DataSourceBuilder credentials(String user, String password) {
            this.m.credentials = new SaharaDataSourceCredentials(user, password);
            return this;
        }

        @Override
        public DataSource build() {
            return this.m;
        }

        @Override
        public DataSourceBuilder from(DataSource in) {
            this.m = (SaharaDataSource)in;
            return this;
        }
    }

    public static class DataSources
    extends ListResult<SaharaDataSource> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="data_sources")
        private List<SaharaDataSource> datasources;

        @Override
        public List<SaharaDataSource> value() {
            return this.datasources;
        }
    }
}

