/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.factories;

import java.util.Map;
import org.pojava.exception.PersistenceException;
import org.pojava.persistence.factories.SerialFactory;
import org.pojava.util.EncodingTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFactory
implements SerialFactory<Object> {
    private Boolean parseBoolean(String var) {
        char[] chars;
        if (var == null) {
            return Boolean.FALSE;
        }
        for (char c : chars = var.toCharArray()) {
            if (c != 'Y' && c != 'y' && c != '1' && c != 'T' && c != 't') continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object construct(Class type, Object[] values) {
        if (values == null || values.length != 1) {
            throw new PersistenceException("The DefaultConstructor only accepts an array of one String.", null);
        }
        String value = values[0].toString();
        if (type == String.class) {
            return value;
        }
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return new Integer(value.trim());
            }
            if (type == Long.TYPE) {
                return new Long(value);
            }
            if (type == Character.TYPE) {
                if (value.length() > 0) {
                    return Character.valueOf(value.charAt(0));
                }
            } else {
                if (type == Byte.TYPE) {
                    if (value.length() == 2) {
                        return EncodingTool.hexDecode((String)value);
                    }
                    throw new PersistenceException("byte.class cannot decode hex value '" + value + "'", null);
                }
                if (type == Boolean.TYPE) {
                    return this.parseBoolean(value);
                }
                if (type == Double.TYPE) {
                    return new Double(value);
                }
                if (type == Float.TYPE) {
                    return new Float(value);
                }
                if (type == Short.TYPE) {
                    return new Short(value);
                }
            }
        }
        if (type.getName().startsWith("java.lang.")) {
            if (type == Integer.class) {
                return new Integer(value.trim());
            }
            if (type == Character.class) {
                if (value.length() > 0) {
                    return Character.valueOf(value.charAt(0));
                }
            } else if (type == Byte.class) {
                if (value.length() == 2) {
                    return EncodingTool.hexDecode((String)value);
                }
            } else {
                if (type == Boolean.class) {
                    return this.parseBoolean(value);
                }
                if (type == Class.class) {
                    try {
                        return Class.forName(value);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new PersistenceException("ClassNotFoundException creating class '" + value + "'", (Throwable)ex);
                    }
                }
                if (type == Double.class) {
                    return new Double(value);
                }
                if (type == Float.class) {
                    return new Float(value);
                }
                if (type == Long.class) {
                    return new Long(value);
                }
                if (type == Object.class) {
                    return new Object();
                }
                if (type == Short.class) {
                    return new Short(value);
                }
                if (type == StringBuffer.class) {
                    return new StringBuffer(value);
                }
            }
        }
        return null;
    }

    @Override
    public Object construct(Class type, Map params) {
        if (params.containsKey("value")) {
            Object[] values = new Object[]{params.get("value")};
            return this.construct(type, values);
        }
        return this.construct(type, params.entrySet().toArray());
    }

    @Override
    public String serialize(Object obj) {
        return obj.toString().trim().replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

