/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.jndi;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverManagerDataSource
implements DataSource {
    private static Logger LOGGER = Logger.getLogger("org.pojava.persistence.jndi.DriverManagerDataSource");
    String url;
    String user;
    String password;
    int loginTimeout = 0;
    PrintWriter logWriter;

    public DriverManagerDataSource(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
        return conn;
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        Connection conn = DriverManager.getConnection(this.url, userName, password);
        return conn;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return LOGGER;
    }

    @Override
    public <T> T unwrap(Class<T> c) {
        return null;
    }

    @Override
    public void setLoginTimeout(int time) {
        this.loginTimeout = time;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    public boolean isWrapperFor(Class<?> type) {
        return false;
    }
}

