/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.jndi;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.pojava.persistence.jndi.DriverManagerDataSource;

public class JNDIRegistry {
    private static Logger logger = Logger.getLogger("org.pojava.persistence.jndi.JNDIRegistry");

    private JNDIRegistry() {
    }

    public static Context getInitialContext() throws NamingException {
        String initialContextFactory = "org.pojava.persistence.jndi.TestingContextFactory";
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", initialContextFactory);
        System.setProperty("java.naming.factory.initial", initialContextFactory);
        return new InitialContext(env);
    }

    public static Context getInitialContext(String initialContextFactory) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", initialContextFactory);
        System.setProperty("java.naming.factory.initial", initialContextFactory);
        return new InitialContext(env);
    }

    public static Object lookupEnv(String name) throws NamingException {
        InitialContext ctx = new InitialContext();
        return ctx.lookup("java:comp/env/" + name);
    }

    public static DataSource lookupDataSource(String key) throws NamingException {
        InitialContext ctx = new InitialContext();
        return (DataSource)ctx.lookup("java:comp/env/jdbc/" + key);
    }

    public static Object lookupFullyQualified(String name) throws NamingException {
        InitialContext ctx = new InitialContext();
        return ctx.lookup(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties fetchProperties(String propertyFile) throws IOException {
        Properties dataSourceProps = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertyFile);
            dataSourceProps.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "IOException occurred trying to read " + propertyFile, ex);
                }
            }
        }
        return dataSourceProps;
    }

    public static DataSource extractDataSource(Properties props, String dsName) throws ClassNotFoundException {
        String url = props.getProperty(dsName + ".url");
        String user = props.getProperty(dsName + ".user");
        String password = props.getProperty(dsName + ".password");
        String driver = props.getProperty(dsName + ".driver");
        Class.forName(driver);
        return new DriverManagerDataSource(url, user, password);
    }

    public static void registerDatasourcesFromFile(String propertyFile) throws ClassNotFoundException, NamingException, IOException {
        Properties dataSourceProps = JNDIRegistry.fetchProperties(propertyFile);
        String propNamesCSV = (String)dataSourceProps.get("datasource_names");
        if (propNamesCSV == null) {
            throw new IllegalStateException("No datasource_names property found in propertyFile: " + propertyFile);
        }
        String[] propNames = propNamesCSV.split("[ ,|]+");
        Context context = JNDIRegistry.getInitialContext();
        for (String propName : propNames) {
            DataSource ds = JNDIRegistry.extractDataSource(dataSourceProps, propName);
            context.bind("java:comp/env/jdbc/" + propName, (Object)ds);
        }
    }
}

