/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.jndi;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestingContext
implements Context {
    private Hashtable<String, Object> map = new Hashtable();
    private String prefix = null;
    private Context parentContext = null;

    private String normalized(String name) {
        return name.replaceAll(":/?", "/");
    }

    private String normalized(Name name) {
        return name.toString().replaceAll(":/?", "/");
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new UnsupportedOperationException("addToEnvironment(String propName, Object propVal) Not implemented.");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(this.normalized(name), obj);
        if (this.parentContext != null) {
            this.parentContext.bind(this.prefix + "/" + this.normalized(name), obj);
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.map.put(this.normalized(name), obj);
        if (this.parentContext != null) {
            this.parentContext.bind(this.prefix + "/" + this.normalized(name), obj);
        }
    }

    @Override
    public void close() throws NamingException {
        this.map = null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException("composeName(Name name, Name prefix) Not implemented.");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException("composeName(String name, String prefix) Not implemented.");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("createSubcontext(Name name) Not implemented.");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("createSubcontext(String name) Not implemented.");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("destroySubcontext(Name name) Not implemented.");
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("destroySubcontext(String name) Not implemented.");
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        throw new UnsupportedOperationException("getEnvironment() Not implemented.");
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new UnsupportedOperationException("getNameInNamespace() Not implemented.");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException("getNameParser(Name name) Not implemented.");
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException("getNameParser(String name) Not implemented.");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new UnsupportedOperationException("list(Name name) Not implemented.");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw new UnsupportedOperationException("list(String name) Not implemented.");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException("listBindings(Name name) Not implemented.");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw new UnsupportedOperationException("listBindings(String name) Not implemented.");
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(this.normalized(name));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object target = this.map.get(name = this.normalized(name));
        if (target == null) {
            Hashtable<String, Object> submap = new Hashtable<String, Object>();
            for (String key : this.map.keySet()) {
                if (!key.startsWith(name + "/")) continue;
                submap.put(key.substring(name.length() + 1), this.map.get(key));
            }
            if (submap.size() > 0) {
                TestingContext ctx = new TestingContext();
                ctx.map = submap;
                ctx.parentContext = this;
                ctx.prefix = name;
                target = ctx;
            }
        }
        return target;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException("lookupLink(Name name) Not implemented.");
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException("lookupLink(String name) Not implemented.");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.bind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.bind(name, obj);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new UnsupportedOperationException("removeFromEnvironment(String propName) Not implemented.");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.map.put(this.normalized(newName), this.map.remove(this.normalized(oldName)));
        if (this.parentContext != null) {
            this.parentContext.rename(this.prefix + "/" + this.normalized(oldName), this.prefix + "/" + this.normalized(newName));
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.map.put(this.normalized(newName), this.map.remove(this.normalized(oldName)));
        if (this.parentContext != null) {
            this.parentContext.rename(this.prefix + "/" + this.normalized(oldName), this.prefix + "/" + this.normalized(newName));
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.map.remove(this.normalized(name));
        if (this.parentContext != null) {
            this.parentContext.unbind(this.prefix + "/" + this.normalized(name));
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.map.remove(this.normalized(name));
        if (this.parentContext != null) {
            this.parentContext.unbind(this.prefix + "/" + this.normalized(name));
        }
    }
}

