/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.processor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.pojava.persistence.processor.ResultSetProcessor;
import org.pojava.persistence.sql.TableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetToList<T>
implements ResultSetProcessor {
    private List<T> list = null;
    private TableMap<T> map = null;

    public ResultSetToList(TableMap<T> map, List<T> list) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot construct a ResultSetToList with a null map.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Cannot construct a ResultSetToList with a null list.");
        }
        this.list = list;
        this.map = map;
    }

    @Override
    public int process(ResultSet rs) throws SQLException {
        int rows = 0;
        while (rs.next()) {
            ++rows;
            this.list.add(this.map.extractObject(rs));
        }
        return rows;
    }
}

