/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.processor;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.pojava.lang.Processor;
import org.pojava.persistence.processor.ResultSetProcessor;
import org.pojava.persistence.sql.TableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetToProcessor<T>
implements ResultSetProcessor {
    private TableMap<T> map = null;
    private Processor<T> processor = null;

    public ResultSetToProcessor(TableMap<T> map, Processor<T> processor) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot construct a ResultSetToList with a null map.");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Cannot construct a ResultSetToList with a null processor.");
        }
        this.map = map;
        this.processor = processor;
    }

    @Override
    public int process(ResultSet rs) throws SQLException {
        int rows = 0;
        while (rs.next()) {
            ++rows;
            this.processor.process(this.map.extractObject(rs));
        }
        return rows;
    }
}

