/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.query;

import java.util.Locale;
import org.pojava.lang.BoundString;
import org.pojava.persistence.query.AbstractQuery;
import org.pojava.persistence.query.PreparedSql;
import org.pojava.persistence.query.PreparedSqlProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQuery
extends AbstractQuery
implements PreparedSqlProvider {
    protected final BoundString sql = new BoundString();
    protected String sqlOrderBy = null;

    public SqlQuery() {
    }

    public SqlQuery(BoundString boundSql) {
        if (boundSql == null) {
            return;
        }
        this.appendSql(boundSql);
    }

    public SqlQuery(BoundString boundSql, int maxRows) {
        if (boundSql == null) {
            return;
        }
        this.appendSql(boundSql);
        super.setMaxRows(maxRows);
    }

    protected void appendSql(BoundString newSql) {
        this.sql.append(newSql);
    }

    protected void appendSql(String newSql) {
        this.sql.append(newSql);
    }

    protected void addBinding(Class<Object> type, Object value) {
        this.sql.addBinding(type, value);
    }

    protected void insertSql(BoundString newSql) {
        this.sql.insert(newSql);
    }

    protected void insertSql(String newSql) {
        this.sql.insert(newSql);
    }

    protected void whereAnd(String newSql) {
        this.sql.append(this.sql.getString().length() == 0 ? "WHERE " : " AND ");
        this.sql.append(newSql);
    }

    protected void whereAnd(BoundString predicate) {
        this.sql.append(this.sql.getString().length() == 0 ? "WHERE " : " AND ");
        this.sql.append(predicate);
    }

    @Override
    public PreparedSql generatePreparedSql(String prefix) {
        return this.generatePreparedSql(new BoundString(prefix));
    }

    @Override
    public PreparedSql generatePreparedSql(BoundString prefix) {
        BoundString bs = new BoundString();
        bs.append(prefix);
        bs.append(" ");
        bs.append(this.sql);
        if (this.sqlOrderBy != null && this.sqlOrderBy.trim().length() > 0) {
            String verify = this.sqlOrderBy.toUpperCase(Locale.ENGLISH).replace('\t', ' ').trim();
            if (verify.startsWith("ORDER BY ")) {
                bs.append(" ");
            } else {
                bs.append(" ORDER BY ");
            }
            bs.append(this.sqlOrderBy.trim());
        }
        return new PreparedSql(bs, super.getMaxRows());
    }
}

