/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.serial;

import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pojava.datetime.DateTime;
import org.pojava.exception.InconceivableException;
import org.pojava.exception.PersistenceException;
import org.pojava.lang.Accessors;
import org.pojava.persistence.factories.DateFactory;
import org.pojava.persistence.factories.DateTimeFactory;
import org.pojava.persistence.factories.DefaultFactory;
import org.pojava.persistence.factories.SerialFactory;
import org.pojava.persistence.serial.RenamedFields;
import org.pojava.util.ReflectionTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDefs {
    public Map<Class<?>, SerialFactory<?>> factories = new HashMap();
    private SerialFactory<?> defaultFactory = new DefaultFactory();
    private Map<Object, Integer> referenced = new HashMap<Object, Integer>();
    private Map<Object, Integer> serialized = new HashMap<Object, Integer>();
    private Map<Class<?>, RenamedFields> renamed = new HashMap();
    private Map<Class<?>, Set<String>> omissions = new HashMap();
    private Map<Class<?>, Map<String, Class<?>>> properties = new HashMap();
    private Map<Class<?>, Accessors> accessors = new HashMap();
    private int referenceId = 1;
    private int padSize = 2;
    private String pad = "                                                                ";
    private boolean omittingNulls = false;
    private boolean ignoringInvocationTargetException = false;
    private boolean ignoringIllegalAccessException = false;

    public XmlDefs() {
        this.registerFactories();
        this.registerCustomAccessors();
    }

    private void registerCustomAccessors() {
        Class[] timeParams = new Class[]{Long.TYPE};
        Class[] nanosParams = new Class[]{Integer.TYPE};
        try {
            Accessors getterSetters = new Accessors();
            Map getters = getterSetters.getGetters();
            Map setters = getterSetters.getSetters();
            Class type = Timestamp.class;
            getterSetters.setType(type);
            getters.put("getTime", type.getMethod("getTime", null));
            getters.put("getNanos", type.getMethod("getNanos", null));
            setters.put("setTime", type.getMethod("setTime", timeParams));
            setters.put("setNanos", type.getMethod("setNanos", nanosParams));
            this.accessors.put(type, getterSetters);
            type = Date.class;
            getterSetters = new Accessors();
            getters = getterSetters.getGetters();
            setters = getterSetters.getSetters();
            getterSetters.setType(type);
            getters.put("getTime", type.getMethod("getTime", null));
            setters.put("setTime", type.getMethod("setTime", timeParams));
            this.accessors.put(type, getterSetters);
            type = java.util.Date.class;
            getterSetters = new Accessors();
            getters = getterSetters.getGetters();
            setters = getterSetters.getSetters();
            getterSetters.setType(type);
            getters.put("getTime", type.getMethod("getTime", null));
            setters.put("setTime", type.getMethod("setTime", timeParams));
            this.accessors.put(type, getterSetters);
        }
        catch (NoSuchMethodException ex) {
            throw new InconceivableException("Unless Java discontinued Timestamp, this should never occur.", (Throwable)ex);
        }
    }

    private void registerFactories() {
        this.registerFactory(java.util.Date.class, new DateFactory());
        this.registerFactory(Date.class, new DateFactory());
        this.registerFactory(Timestamp.class, new DateFactory());
        this.registerFactory(DateTime.class, new DateTimeFactory());
        this.registerFactory(Integer.class, this.defaultFactory);
        this.registerFactory(Character.class, this.defaultFactory);
        this.registerFactory(Long.class, this.defaultFactory);
        this.registerFactory(Byte.class, this.defaultFactory);
        this.registerFactory(Boolean.class, this.defaultFactory);
        this.registerFactory(Float.class, this.defaultFactory);
        this.registerFactory(Short.class, this.defaultFactory);
        this.registerFactory(String.class, this.defaultFactory);
    }

    public void registerFactory(Class<?> type, SerialFactory<?> factory) {
        this.factories.put(type, factory);
    }

    public SerialFactory<?> factory(Class<?> type) {
        return this.factories.get(type);
    }

    public Object construct(Class<?> type, Object[] params) {
        SerialFactory<?> factory = this.factories.get(type);
        if (factory == null) {
            factory = this.defaultFactory;
        }
        return factory.construct(type, params);
    }

    private void fillCollection(Collection<Object> col, Map<?, ?> params) {
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                col.add(params.get(i));
            }
        }
    }

    public Object construct(Class type, Map params) {
        SerialFactory<?> factory = this.factories.get(type);
        try {
            if (factory == null) {
                Collection<Object> newObj;
                if (List.class.equals((Object)type) || Collection.class.equals((Object)type)) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    this.fillCollection(list, params);
                    newObj = list;
                } else if (Set.class.equals((Object)type)) {
                    HashSet<Object> set = new HashSet<Object>();
                    this.fillCollection(set, params);
                    newObj = set;
                } else if (Collection.class.isAssignableFrom(type)) {
                    Collection col = (Collection)type.newInstance();
                    this.fillCollection(col, params);
                    newObj = col;
                } else {
                    newObj = type.newInstance();
                    Accessors accessors = ReflectionTool.accessors((Class)type);
                    ReflectionTool.populateFromMap(newObj, (Map)params, (Map)accessors.getSetters());
                }
                return newObj;
            }
            return factory.construct(type, params);
        }
        catch (InstantiationException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean isValue(Class<?> type) {
        return type != null && (type.isPrimitive() || this.factories.containsKey(type));
    }

    public boolean isReferenced(Object obj) {
        return this.referenced.containsKey(obj);
    }

    public Integer getReferenceId(Object obj) {
        return this.referenced.get(obj);
    }

    public boolean isSerialized(Object obj) {
        return this.serialized.containsKey(obj);
    }

    public Integer register(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        if (!(type.isArray() || this.hasAccessors(type) || Collection.class.isAssignableFrom(type) || AbstractMap.class.isAssignableFrom(type))) {
            this.addAccessors(ReflectionTool.accessors(type));
        }
        Integer refId = null;
        if (this.serialized.containsKey(obj)) {
            refId = this.serialized.get(obj);
            if (refId == 0) {
                refId = this.referenceId++;
                this.serialized.put(obj, refId);
                this.referenced.put(obj, refId);
            }
        } else if (this.referenced.containsKey(obj)) {
            this.serialized.put(obj, this.referenced.get(obj));
        } else {
            this.serialized.put(obj, 0);
        }
        return refId;
    }

    public void resetRegistry() {
        this.serialized.clear();
        this.referenceId = 1;
    }

    public void rename(Class<?> type, String property, String xmlName) {
        RenamedFields rf;
        if (this.renamed.containsKey(type)) {
            rf = this.renamed.get(type);
        } else {
            rf = new RenamedFields();
            this.renamed.put(type, rf);
        }
        rf.rename(property, xmlName);
    }

    public String renamedXml(Class<?> type, String name) {
        if (this.renamed.containsKey(type)) {
            RenamedFields rf = this.renamed.get(type);
            return rf.javaNameFor(name);
        }
        return name;
    }

    public String renamedJava(Class<?> type, String name) {
        if (this.renamed.containsKey(type)) {
            RenamedFields rf = this.renamed.get(type);
            return rf.xmlNameFor(name);
        }
        return name;
    }

    public String indent(int depth) {
        while (this.pad.length() < depth * this.padSize) {
            this.pad = this.pad + this.pad;
        }
        return this.pad.substring(0, depth * this.padSize);
    }

    public void addOmission(Class<?> type, String property) {
        Set<Object> propertySet;
        if (this.omissions.containsKey(type)) {
            propertySet = this.omissions.get(type);
        } else {
            propertySet = new HashSet();
            this.omissions.put(type, propertySet);
        }
        propertySet.add(property);
    }

    public boolean isOmission(Class<?> type, String property) {
        return this.omissions.containsKey(type) && this.omissions.get(type).contains(property);
    }

    public Map<String, Class<?>> getProperties(Class<?> type) {
        Map props = this.properties.get(type);
        if (props == null) {
            props = ReflectionTool.propertyMap(type);
            this.properties.put(type, props);
        }
        return props;
    }

    public boolean hasAccessors(Class<?> type) {
        return this.accessors.containsKey(type);
    }

    public Accessors getAccessors(Class<?> type) {
        return this.accessors.get(type);
    }

    public void addAccessors(Accessors accessor) {
        this.accessors.put(accessor.getType(), accessor);
    }

    public boolean isOmittingNulls() {
        return this.omittingNulls;
    }

    public void setOmittingNulls(boolean omittingNulls) {
        this.omittingNulls = omittingNulls;
    }

    public boolean isIgnoringInvocationTargetException() {
        return this.ignoringInvocationTargetException;
    }

    public void setIgnoringInvocationTargetException(boolean ignoringInvocationTargetException) {
        this.ignoringInvocationTargetException = ignoringInvocationTargetException;
    }

    public boolean isIgnoringIllegalAccessException() {
        return this.ignoringIllegalAccessException;
    }

    public void setIgnoringIllegalAccessException(boolean ignoringIllegalAccessException) {
        this.ignoringIllegalAccessException = ignoringIllegalAccessException;
    }
}

