/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.serial;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pojava.datetime.DateTime;
import org.pojava.exception.PersistenceException;
import org.pojava.persistence.serial.XmlDefs;
import org.pojava.util.ReflectionTool;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParser<T>
implements ContentHandler {
    private static Logger logger = Logger.getLogger("org.pojava.persistence.serial.XmlParser");
    private static final String SAX_DRIVER = "org.xml.sax.driver";
    private static final String XERCES_PARSER = "org.apache.xerces.parsers.SAXParser";
    private static final String CRIMSON_PARSER = "org.apache.crimson.parser.XMLReaderImpl";
    private static final String AELFRED_PARSER = "gnu.xml.aelfred2.XmlReader";
    private static final String PICCOLO_PARSER = "com.bluecast.xml.Piccolo";
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private int depth = 0;
    private int size = 8;
    Map<Object, Object>[] objs = new Map[this.size];
    StringBuffer[] buffers = new StringBuffer[this.size];
    Class<?>[] types = new Class[this.size];
    XmlDefs defs;
    Map<String, String> refNames = new HashMap<String, String>();
    Map<String, String> refValues = new HashMap<String, String>();
    String[] fqprops = new String[this.size];

    public XmlParser() {
        this.defs = new XmlDefs();
    }

    public XmlParser(XmlDefs defs) {
        this.defs = defs;
    }

    public T parse(String xml) {
        XMLReader parser;
        InputSource inp = new InputSource(new StringReader(xml));
        try {
            parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e1) {
            try {
                parser = XMLReaderFactory.createXMLReader(XERCES_PARSER);
                System.setProperty(SAX_DRIVER, XERCES_PARSER);
            }
            catch (SAXException e2) {
                try {
                    parser = XMLReaderFactory.createXMLReader(CRIMSON_PARSER);
                    System.setProperty(SAX_DRIVER, CRIMSON_PARSER);
                }
                catch (SAXException e3) {
                    try {
                        parser = XMLReaderFactory.createXMLReader(AELFRED_PARSER);
                        System.setProperty(SAX_DRIVER, AELFRED_PARSER);
                    }
                    catch (SAXException e4) {
                        try {
                            parser = XMLReaderFactory.createXMLReader(PICCOLO_PARSER);
                            System.setProperty(SAX_DRIVER, PICCOLO_PARSER);
                        }
                        catch (SAXException e5) {
                            throw new PersistenceException("No SAX parser is available", (Throwable)e5);
                        }
                    }
                }
            }
        }
        parser.setContentHandler(this);
        try {
            parser.parse(inp);
        }
        catch (SAXException ex1) {
            throw new PersistenceException("Parse failure: " + ex1.getMessage(), (Throwable)ex1);
        }
        catch (IOException ex2) {
            throw new PersistenceException("Parse failure: " + ex2.getMessage(), (Throwable)ex2);
        }
        return (T)this.objs[0].values().toArray()[0];
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.fqprops[0] = "";
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        try {
            ++this.depth;
            if (this.depth >= this.size) {
                Map[] moreObjs = new Map[this.size * 2];
                Class[] moreTypes = new Class[this.size * 2];
                StringBuffer[] moreBuffers = new StringBuffer[this.size * 2];
                String[] moreFqprops = new String[this.size * 2];
                System.arraycopy(this.objs, 0, moreObjs, 0, this.size);
                System.arraycopy(this.buffers, 0, moreBuffers, 0, this.size);
                System.arraycopy(this.types, 0, moreTypes, 0, this.size);
                System.arraycopy(this.fqprops, 0, moreFqprops, 0, this.size);
                this.objs = moreObjs;
                this.types = moreTypes;
                this.buffers = moreBuffers;
                this.fqprops = moreFqprops;
                this.size *= 2;
            }
            if (this.buffers[this.depth] == null) {
                this.buffers[this.depth] = new StringBuffer();
            } else {
                this.buffers[this.depth].setLength(0);
            }
            if (this.fqprops[this.depth] != null) {
                this.fqprops[this.depth] = null;
            }
            if ("null".equals(localName)) {
                this.objs[this.depth - 1] = new HashMap<Object, Object>();
                return;
            }
            StringBuffer sb = this.buffers[this.depth];
            if (this.depth > 1) {
                sb.append(this.fqprops[this.depth - 1]);
                sb.append('.');
            }
            sb.append(localName);
            this.fqprops[this.depth] = sb.toString();
            sb.setLength(0);
            if (!"obj".equals(localName)) {
                this.types[this.depth] = Map.class.isAssignableFrom(this.types[this.depth - 1]) ? Object[].class : (this.types[this.depth - 1].isArray() ? this.types[this.depth - 1].getComponentType() : ReflectionTool.propertyType(this.types[this.depth - 1], (String)localName));
            }
            boolean isMem = false;
            boolean isRef = false;
            String id = null;
            for (int i = 0; i < atts.getLength(); ++i) {
                String attribName = atts.getLocalName(i);
                if ("class".equals(attribName) || "type".equals(attribName)) {
                    if (atts.getValue(i).indexOf(46) <= 0) {
                        if (atts.getValue(i).equals("DateTime")) {
                            this.types[this.depth] = DateTime.class;
                        } else {
                            char c = atts.getValue(i).charAt(0);
                            if (c >= 'A' && c <= 'Z') {
                                sb.append("java.lang.");
                            }
                            sb.append(atts.getValue(i));
                            this.types[this.depth] = Class.forName(sb.toString());
                        }
                        sb.setLength(0);
                        continue;
                    }
                    this.types[this.depth] = Class.forName(atts.getValue(i));
                    continue;
                }
                if ("mem".equals(attribName)) {
                    isMem = true;
                    id = atts.getValue(i);
                    continue;
                }
                if (!"ref".equals(attribName)) continue;
                isRef = true;
                id = atts.getValue(i);
            }
            if (isMem) {
                this.refNames.put(id, this.fqprops[this.depth]);
            } else if (isRef) {
                this.refValues.put(this.fqprops[this.depth], this.refNames.get(id));
            }
            if (this.objs[this.depth - 1] == null) {
                this.objs[this.depth - 1] = new HashMap<Object, Object>();
            }
        }
        catch (ClassNotFoundException ex) {
            throw new PersistenceException("ClassNotFound: " + ex.getMessage(), (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new PersistenceException("NoSuchMethod: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void giveParent(Object key, Object value) {
        if ("obj".equals(key)) {
            this.objs[this.depth - 1].put(this.objs[this.depth - 1].size(), value);
        } else {
            this.objs[this.depth - 1].put(key, value);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        block42: {
            Object key = this.types[this.depth - 1] != null && this.types[this.depth - 1].isArray() && !"null".equals(localName) ? Integer.valueOf(this.objs[this.depth - 1].size()) : localName;
            if ("null".equals(key)) {
                this.objs[this.depth - 1].put(key, null);
            } else if (this.defs.isValue(this.types[this.depth])) {
                if (this.objs[this.depth] != null && this.objs[this.depth].containsKey(0) && this.buffers[this.depth].length() == 0) {
                    this.objs[this.depth - 1].put(key, this.objs[this.depth].get(0));
                } else if (this.objs[this.depth] != null && this.objs[this.depth].containsKey("null")) {
                    this.giveParent(key, null);
                } else {
                    Object[] params = new Object[]{this.buffers[this.depth].toString()};
                    this.giveParent(key, this.defs.construct(this.types[this.depth], params));
                }
            } else if (this.types[this.depth] == null) {
                this.objs[this.depth - 1].put(key, null);
            } else if (this.types[this.depth].isArray()) {
                if (this.objs[this.depth] == null) {
                    Object array = Array.newInstance(this.types[this.depth].getComponentType(), 0);
                    if (this.types[this.depth - 1] == Object.class) {
                        this.objs[this.depth - 1].put(ZERO, array);
                    } else {
                        this.objs[this.depth - 1].put(key, array);
                    }
                } else if (this.types[this.depth - 1] != null && Map.class.isAssignableFrom(this.types[this.depth - 1])) {
                    Map<Object, Object> map;
                    if (this.objs[this.depth - 1].containsKey(ZERO)) {
                        map = (Map)this.objs[this.depth - 1].get(ZERO);
                    } else {
                        map = new HashMap();
                        this.objs[this.depth - 1].put(ZERO, map);
                    }
                    if (this.objs[this.depth] != null && this.objs[this.depth].containsKey(ZERO)) {
                        map.put(this.objs[this.depth].get(ZERO), this.objs[this.depth].get(ONE));
                    }
                } else if (!this.objs[this.depth].containsKey("null")) {
                    Object array = Array.newInstance(this.types[this.depth].getComponentType(), this.objs[this.depth].size());
                    for (int i = 0; i < this.objs[this.depth].size(); ++i) {
                        Array.set(array, i, this.objs[this.depth].get(i));
                    }
                    if (this.types[this.depth - 1] == Object.class) {
                        this.objs[this.depth - 1].put(ZERO, array);
                    } else {
                        this.objs[this.depth - 1].put(key, array);
                    }
                }
            } else if (this.types[this.depth].isEnum()) {
                try {
                    Class<?> pc = this.types[this.depth];
                    if (Object.class.equals(this.types[this.depth - 1])) {
                        this.objs[this.depth - 1].put(ZERO, Enum.valueOf(pc, this.buffers[this.depth].toString()));
                        break block42;
                    }
                    this.objs[this.depth - 1].put(key, Enum.valueOf(pc, this.buffers[this.depth].toString()));
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            } else if (!this.refValues.containsKey(this.fqprops[this.depth])) {
                if (this.types[this.depth] == Object.class) {
                    if (this.objs[this.depth] == null || this.objs[this.depth].size() == 0) {
                        this.giveParent(key, new Object());
                    } else {
                        this.giveParent(key, this.objs[this.depth].get(ZERO));
                        this.objs[this.depth].clear();
                    }
                } else if (Map.class.isAssignableFrom(this.types[this.depth])) {
                    this.objs[this.depth - 1].put(key, this.objs[this.depth].get(ZERO));
                } else if (this.objs[this.depth] == null || this.objs[this.depth].containsKey("null")) {
                    if (Object.class.isAssignableFrom(this.types[this.depth])) {
                        this.objs[this.depth - 1].put(key, null);
                    }
                } else {
                    if (this.types[this.depth - 1] != null && Collection.class.isAssignableFrom(this.types[this.depth - 1])) {
                        key = this.objs[this.depth - 1].size();
                    }
                    this.objs[this.depth - 1].put(key, this.defs.construct(this.types[this.depth], this.objs[this.depth]));
                }
            }
        }
        if (this.objs[this.depth] != null) {
            this.objs[this.depth].clear();
            this.types[this.depth] = null;
        }
        --this.depth;
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.refValues.size() > 0) {
            Resolver resolver = new Resolver(this.objs[0].values().toArray()[0]);
            for (String ref : this.refValues.keySet()) {
                String mem = this.refValues.get(ref);
                Object memObj = ReflectionTool.getNestedValue((String)mem, (Object)resolver);
                try {
                    ReflectionTool.setNestedValue((String)ref, (Object)resolver, (Object)memObj);
                }
                catch (Exception ex) {
                    throw new PersistenceException("Could not resolve " + ref + " into " + mem, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        char[] buf = new char[length];
        System.arraycopy(ch, start, buf, 0, length);
        this.buffers[this.depth].append(buf);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    protected static class Resolver {
        Object obj;

        public Resolver(Object obj) {
            this.obj = obj;
        }

        public Object getObj() {
            return this.obj;
        }
    }
}

