/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.serial;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import org.pojava.exception.PersistenceException;
import org.pojava.lang.Accessors;
import org.pojava.persistence.factories.SerialFactory;
import org.pojava.persistence.serial.XmlDefs;
import org.pojava.util.ReflectionTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSerializer {
    private XmlDefs config;

    public XmlSerializer() {
        this.config = new XmlDefs();
    }

    public XmlSerializer(XmlDefs config) {
        this.config = config;
    }

    private void walk(Object pojo) {
        Integer ref;
        if (pojo == null) {
            return;
        }
        if (!ReflectionTool.isBasic(pojo.getClass()) && (ref = this.config.register(pojo)) != null) {
            return;
        }
        Class<?> type = pojo.getClass();
        if (ReflectionTool.isBasic(type) || type.equals(Object.class) || type.equals(Class.class)) {
            return;
        }
        if (this.config.hasAccessors(type)) {
            Map getters = this.config.getAccessors(type).getGetters();
            for (Map.Entry entry : getters.entrySet()) {
                String property = (String)entry.getKey();
                if (this.config.isOmission(type, property)) continue;
                try {
                    Object obj = ((Method)entry.getValue()).invoke(pojo, (Object[])null);
                    this.walk(obj);
                }
                catch (IllegalAccessException ex) {
                    if (this.config.isIgnoringIllegalAccessException()) continue;
                    throw new PersistenceException("Could not serialize " + pojo.getClass().getName(), (Throwable)ex);
                }
                catch (InvocationTargetException ex2) {
                    if (this.config.isIgnoringInvocationTargetException()) continue;
                    throw new PersistenceException("Could not serialize " + pojo.getClass().getName(), (Throwable)ex2);
                }
            }
        } else if (Collection.class.isAssignableFrom(type)) {
            Collection collection = (Collection)pojo;
            for (Object aCollection : collection) {
                this.walk(aCollection);
            }
        } else if (AbstractMap.class.isAssignableFrom(type)) {
            Map map = (Map)pojo;
            for (Map.Entry entry1 : map.entrySet()) {
                this.walk(entry1.getKey());
                this.walk(entry1.getValue());
            }
        } else if (type.isArray()) {
            int length = Array.getLength(pojo);
            for (int i = 0; i < length; ++i) {
                this.walk(Array.get(pojo, i));
            }
        } else {
            Accessors accessors = ReflectionTool.accessors(type);
            this.config.addAccessors(accessors);
            Map getters = accessors.getGetters();
            for (String s : getters.keySet()) {
                try {
                    Method meth = (Method)getters.get(s);
                    this.walk(meth.invoke(pojo, (Object[])null));
                }
                catch (InvocationTargetException ex1) {
                    throw new PersistenceException("Couldn't walk. " + ex1.toString(), (Throwable)ex1);
                }
                catch (IllegalAccessException ex2) {
                    throw new PersistenceException("Couldn't walk. " + ex2.toString(), (Throwable)ex2);
                }
            }
        }
    }

    public String toXml(Object obj) {
        this.walk(obj);
        this.config.resetRegistry();
        return this.toXml(obj, null, null, 0, null);
    }

    private String toXml(Object pojo, String name, String attribs, int depth, Class<?> baseClass) {
        SerialFactory<?> override;
        if (pojo == null) {
            if (this.config.isOmittingNulls()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            this.openTag(sb, name, attribs, depth);
            sb.append("<null/>");
            this.closeTag(sb, name);
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer();
        StringBuilder attribSb = new StringBuilder();
        Class<?> type = pojo.getClass();
        if (attribs != null) {
            attribSb.append(attribs);
        }
        if (name == null || name.length() == 0) {
            attribSb.append(" class=\"");
            attribSb.append(this.className(pojo));
            attribSb.append('\"');
            name = "obj";
        }
        if (baseClass == null) {
            baseClass = pojo.getClass();
        }
        Integer refId = null;
        if (!ReflectionTool.isBasic(type) && (refId = this.config.getReferenceId(pojo)) != null) {
            if (refId != this.config.register(pojo)) {
                refId = this.config.getReferenceId(pojo);
                attribSb.append(" mem=\"");
                attribSb.append(refId);
                attribSb.append("\"");
            } else {
                sb.append(this.config.indent(depth));
                name = this.config.renamedJava(type, name);
                sb.append("<");
                sb.append(name);
                sb.append(" ref=\"");
                sb.append(refId);
                sb.append("\"/>\n");
                return sb.toString();
            }
        }
        if ((override = this.config.factory(type)) != null) {
            name = this.config.renamedJava(baseClass, name);
            this.openTag(sb, name, attribSb.toString(), depth);
            sb.append(override.serialize(pojo));
            this.closeTag(sb, name);
            return sb.toString();
        }
        if (ReflectionTool.isBasic(type) || type.isEnum()) {
            sb.append(this.config.indent(depth));
            sb.append(this.simpleElement(pojo, name, attribSb.toString()));
        } else if (type.equals(Object.class)) {
            sb.append(this.snippetFromUntyped(pojo, name, attribSb.toString(), depth, baseClass));
        } else if (baseClass.equals(Object.class) && Collection.class.isAssignableFrom(type)) {
            sb.append(this.snippetFromUntyped(pojo, name, attribSb.toString(), depth, baseClass));
        } else if (Collection.class.isAssignableFrom(type)) {
            sb.append(this.snippetFromCollection(pojo, name, attribSb.toString(), depth));
        } else if (AbstractMap.class.isAssignableFrom(type)) {
            sb.append(this.snippetFromMap(pojo, name, attribSb.toString(), depth));
        } else if (type.isArray()) {
            sb.append(this.snippetFromArray(pojo, name, attribSb.toString(), depth, baseClass));
        } else {
            sb.append(this.snippetFromPojo(pojo, name, attribSb.toString(), depth, baseClass));
        }
        return sb.toString();
    }

    private String className(Object obj) {
        String name = obj.getClass().getName();
        if (name.startsWith("java.lang.")) {
            return name.substring(10);
        }
        if (name.equals("org.pojava.datetime.DateTime")) {
            return "DateTime";
        }
        return name;
    }

    private String simpleElement(Object value, String name, String attribs) {
        String inner = ReflectionTool.clean((String)value.toString());
        StringBuffer sb = new StringBuffer();
        sb.append('<');
        sb.append(name);
        sb.append(attribs);
        if (inner.length() == 0) {
            sb.append("/>\n");
        } else {
            sb.append('>');
            sb.append(ReflectionTool.clean((String)inner));
            this.closeTag(sb, name);
        }
        return sb.toString();
    }

    private String snippetFromUntyped(Object pojo, String name, String attribs, int depth, Class<?> baseClass) {
        Class<?> memberClass;
        StringBuffer sb = new StringBuffer();
        if (pojo == null) {
            if (this.config.isOmittingNulls()) {
                return "";
            }
            this.openTag(sb, name, null, depth);
            sb.append("<null/>");
            this.closeTag(sb, name);
            return sb.toString();
        }
        boolean isColl = Collection.class.isAssignableFrom(pojo.getClass());
        if (isColl) {
            if (attribs == null || attribs.length() == 0) {
                this.openTag(sb, name, null, depth);
                sb.append('\n');
            }
        } else {
            if (pojo.getClass() == Object.class) {
                sb.append(this.config.indent(depth));
                sb.append('<');
                sb.append(name);
                sb.append(attribs);
                sb.append("/>\n");
                return sb.toString();
            }
            this.openTag(sb, name, attribs, depth);
            sb.append('\n');
        }
        if ((memberClass = pojo.getClass()) != Object.class) {
            sb.append(this.toXml(pojo, null, null, depth + 1, baseClass));
        }
        if (!isColl || attribs == null || attribs.length() == 0) {
            sb.append(this.config.indent(depth));
            this.closeTag(sb, name);
        }
        return sb.toString();
    }

    private String snippetFromCollection(Object pojo, String name, String attribs, int depth) {
        StringBuffer sb = new StringBuffer();
        this.openTag(sb, name, attribs, depth);
        sb.append('\n');
        Collection collection = (Collection)pojo;
        for (Object member : collection) {
            if (member == null) {
                sb.append("<obj class=\"null\"/>\n");
                continue;
            }
            sb.append(this.toXml(member, null, null, depth + 1, member.getClass()));
        }
        sb.append(this.config.indent(depth));
        this.closeTag(sb, name);
        return sb.toString();
    }

    private String snippetFromMap(Object pojo, String name, String attribs, int depth) {
        StringBuffer sb = new StringBuffer();
        this.openTag(sb, name, attribs, depth);
        sb.append('\n');
        Map map = (Map)pojo;
        for (Map.Entry entry1 : map.entrySet()) {
            sb.append(this.config.indent(depth + 1));
            sb.append("<map>\n");
            Object mapKey = entry1.getKey();
            sb.append(this.toXml(mapKey, null, null, depth + 2, mapKey.getClass()));
            Object mapValue = entry1.getValue();
            if (mapValue == null) {
                sb.append(this.config.indent(depth + 2));
                sb.append("<null/>\n");
            } else {
                sb.append(this.toXml(mapValue, null, null, depth + 2, mapValue.getClass()));
            }
            sb.append(this.config.indent(depth + 1));
            sb.append("</map>\n");
        }
        sb.append(this.config.indent(depth));
        this.closeTag(sb, name);
        return sb.toString();
    }

    private String snippetFromArray(Object pojo, String name, String attribs, int depth, Class<?> baseClass) {
        StringBuffer sb = new StringBuffer();
        int length = Array.getLength(pojo);
        name = this.config.renamedJava(baseClass, name);
        this.openTag(sb, name, attribs, depth);
        sb.append('\n');
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                Object member = Array.get(pojo, i);
                if (member == null) {
                    sb.append(this.toXml(null, "e", null, depth + 1, null));
                    continue;
                }
                sb.append(this.toXml(member, "e", null, depth + 1, member.getClass()));
            }
        }
        sb.append(this.config.indent(depth));
        this.closeTag(sb, name);
        return sb.toString();
    }

    private String snippetFromPojo(Object pojo, String name, String attribs, int depth, Class<?> baseClass) {
        String renamed;
        StringBuffer sb;
        block10: {
            sb = new StringBuffer();
            renamed = this.config.renamedJava(baseClass, name);
            if (renamed == null) {
                this.openTag(sb, name, attribs, depth);
            } else {
                this.openTag(sb, renamed, attribs, depth);
            }
            sb.append('\n');
            Class<?> type = pojo.getClass();
            try {
                Accessors accessors = this.config.getAccessors(type);
                Map getters = accessors.getGetters();
                for (Map.Entry entry : getters.entrySet()) {
                    String property = (String)entry.getKey();
                    Method getter = (Method)entry.getValue();
                    Class<?> fieldClass = getter.getReturnType();
                    if (this.config.isOmission(type, property)) continue;
                    Object innerPojo = ((Method)getters.get(property)).invoke(pojo, (Object[])null);
                    if (fieldClass == Object.class) {
                        sb.append(this.snippetFromUntyped(innerPojo, property, "", depth + 1, fieldClass));
                        continue;
                    }
                    sb.append(this.toXml(innerPojo, property, null, depth + 1, baseClass));
                }
            }
            catch (InvocationTargetException ex) {
                if (!this.config.isIgnoringInvocationTargetException()) {
                    throw new PersistenceException("Could not serialize. " + ex.toString(), (Throwable)ex);
                }
            }
            catch (IllegalAccessException ex) {
                if (this.config.isIgnoringIllegalAccessException()) break block10;
                throw new PersistenceException("Could not serialize. " + ex.toString(), (Throwable)ex);
            }
        }
        sb.append(this.config.indent(depth));
        if (renamed == null) {
            this.closeTag(sb, name);
        } else {
            this.closeTag(sb, renamed);
        }
        return sb.toString();
    }

    private void openTag(StringBuffer sb, String name, String attribs, int depth) {
        sb.append(this.config.indent(depth));
        sb.append('<');
        sb.append(name);
        if (attribs != null) {
            sb.append(attribs);
        }
        sb.append(">");
    }

    private void closeTag(StringBuffer sb, String name) {
        sb.append("</");
        sb.append(name);
        sb.append(">\n");
    }
}

