/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class DataSourceMetadata {
    private String platform;
    private String driverName;
    private String sqlKeywords;
    private String userName;
    private int majorVersion;
    private int minorVersion;

    public DataSourceMetadata() {
    }

    public DataSourceMetadata(Connection conn) throws SQLException {
        this.populateFrom(conn);
    }

    public void populateFrom(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        this.platform = meta.getDatabaseProductName();
        this.majorVersion = meta.getDatabaseMajorVersion();
        this.minorVersion = meta.getDatabaseMinorVersion();
        this.driverName = meta.getDriverName();
        this.sqlKeywords = meta.getSQLKeywords();
        this.userName = meta.getUserName();
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getSqlKeywords() {
        return this.sqlKeywords;
    }

    public void setSqlKeywords(String sqlKeywords) {
        this.sqlKeywords = sqlKeywords;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }
}

