/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.sql;

import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.pojava.persistence.sql.DataSourceMetadata;
import org.pojava.persistence.sql.TableMap;
import org.pojava.persistence.util.SqlTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseCache {
    private static Map<String, DataSourceMetadata> dataSourceMetadataCache = new HashMap<String, DataSourceMetadata>();
    private static Map<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
    private static Map<String, TableMap<?>> tableMapCache = new HashMap();
    private static Map<String, Object> dataSourceLocks = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSourceMetadata getDataSourceMetadata(String dsName) throws SQLException {
        DataSourceMetadata metadata;
        Object lock;
        if (dataSourceMetadataCache.containsKey(dsName)) {
            return dataSourceMetadataCache.get(dsName);
        }
        Object object = dataSourceLocks;
        synchronized (object) {
            lock = dataSourceLocks.get(dsName);
            if (lock == null) {
                lock = new Object();
                dataSourceLocks.put(dsName, lock);
            }
        }
        object = lock;
        synchronized (object) {
            metadata = dataSourceMetadataCache.get(dsName);
            if (metadata == null) {
                DataSource dataSource = DatabaseCache.getDataSource(dsName);
                Connection conn = dataSource.getConnection();
                metadata = new DataSourceMetadata(conn);
                dataSourceMetadataCache.put(dsName, metadata);
            }
        }
        return metadata;
    }

    public static DataSource getDataSource(String dsName) {
        DataSource ds;
        InitialContext ctx;
        if (dataSourceCache.containsKey(dsName)) {
            return dataSourceCache.get(dsName);
        }
        try {
            ctx = new InitialContext();
        }
        catch (NamingException ex) {
            throw new IllegalStateException(ex.getMessage() + "  See org.pojava.persistence.jndi.JNDIRegistry if you need to create an InitialContext for unit testing.");
        }
        try {
            ds = (DataSource)ctx.lookup("java:comp/env/jdbc/" + dsName.trim());
        }
        catch (NamingException ex) {
            throw new InvalidParameterException(dsName.trim() + " triggered NamingException " + ex.getMessage());
        }
        if (ds == null) {
            throw new IllegalStateException("Could not find java:comp/env/jdbc/" + dsName.trim() + " in registry.");
        }
        dataSourceCache.put(dsName, ds);
        return ds;
    }

    private static String tableMapKey(Class<?> javaClass, String tableName, String dataSourceName) {
        return javaClass.getName() + ":" + tableName + ":" + dataSourceName;
    }

    public static void registerTableMap(TableMap<?> tableMap) {
        tableMapCache.put(DatabaseCache.tableMapKey(tableMap.getClass(), tableMap.getTableName(), tableMap.getDataSourceName()), tableMap);
    }

    public static void registerDataSource(String dataSourceName, DataSource dataSource) {
        dataSourceCache.put(dataSourceName, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> TableMap<T> getTableMap(Class<T> javaClass, String tableName, String dataSourceName) {
        TableMap<Object> tableMap;
        Object lock;
        String key = DatabaseCache.tableMapKey(javaClass, tableName, dataSourceName);
        if (tableMapCache.containsKey(key)) {
            return tableMapCache.get(key);
        }
        Map<String, Object> map = dataSourceLocks;
        synchronized (map) {
            lock = dataSourceLocks.get(key);
            if (lock == null) {
                lock = new Object();
                dataSourceLocks.put(key, lock);
            }
        }
        Object object = lock;
        synchronized (object) {
            tableMap = tableMapCache.get(key);
            if (tableMap == null) {
                tableMap = SqlTool.autoGenerateTableMap(javaClass, tableName, dataSourceName);
                tableMapCache.put(key, tableMap);
            }
        }
        return tableMap;
    }
}

