/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.pojava.exception.PersistenceException;
import org.pojava.persistence.sql.ConnectionSource;
import org.pojava.persistence.sql.DatabaseCache;
import org.pojava.persistence.sql.TransConnection;
import org.pojava.persistence.sql.Transaction;

public class DatabaseTransaction
implements Transaction,
ConnectionSource {
    Map<String, Connection> connections = new HashMap<String, Connection>();
    Logger log = Logger.getLogger("org.pojava.database");

    public Connection getConnection(String dataSourceName) throws PersistenceException {
        Connection conn;
        DataSource ds = DatabaseCache.getDataSource(dataSourceName);
        if (ds == null) {
            throw new IllegalStateException("DataSource " + dataSourceName + " not found.");
        }
        if (this.connections.containsKey(dataSourceName)) {
            conn = this.connections.get(dataSourceName);
        } else {
            try {
                conn = new TransConnection(ds.getConnection());
                this.connections.put(dataSourceName, conn);
                this.setDefaults(conn);
            }
            catch (SQLException ex) {
                throw new PersistenceException(ex.getMessage(), (Throwable)ex);
            }
        }
        return conn;
    }

    private void setDefaults(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public void rollback() {
        for (Connection conn : this.connections.values()) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                this.log.severe("Partial rollback failure: " + ex.getMessage());
            }
        }
        this.closeConnections();
    }

    public void commit() {
        for (Connection conn : this.connections.values()) {
            try {
                conn.commit();
            }
            catch (SQLException ex) {
                this.log.severe("Partial commit failure: " + ex.getMessage());
            }
        }
        this.closeConnections();
    }

    private void closeConnections() {
        for (TransConnection transConnection : this.connections.values()) {
            try {
                transConnection.setCloseAllowed(true);
                transConnection.close();
            }
            catch (SQLException ex) {
                this.log.severe("Connection close failure: " + ex.getMessage());
            }
        }
        this.connections.clear();
    }
}

