/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.sql;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.pojava.datetime.DateTime;
import org.pojava.persistence.adaptor.BigDecimalAdaptor;
import org.pojava.persistence.adaptor.BooleanAdaptor;
import org.pojava.persistence.adaptor.ByteAdaptor;
import org.pojava.persistence.adaptor.CharAdaptor;
import org.pojava.persistence.adaptor.DateTimeSqlAdaptor;
import org.pojava.persistence.adaptor.DoubleAdaptor;
import org.pojava.persistence.adaptor.FloatAdaptor;
import org.pojava.persistence.adaptor.IntegerAdaptor;
import org.pojava.persistence.adaptor.LongAdaptor;
import org.pojava.persistence.adaptor.PassthroughAdaptor;
import org.pojava.persistence.adaptor.TimeAdaptor;
import org.pojava.persistence.adaptor.UtilDateSqlAdaptor;
import org.pojava.persistence.sql.AdaptorMap;
import org.pojava.persistence.sql.AdaptorRegistry;
import org.pojava.transformation.BindingAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAdaptorMap<I, O>
implements AdaptorMap<I, O> {
    private static final PassthroughAdaptor DEFAULT_ADAPTOR = new PassthroughAdaptor();
    private static final IntegerAdaptor INTEGER_ADAPTOR = new IntegerAdaptor();
    private static final LongAdaptor LONG_ADAPTOR = new LongAdaptor();
    private static final CharAdaptor CHAR_ADAPTOR = new CharAdaptor();
    private static final DoubleAdaptor DOUBLE_ADAPTOR = new DoubleAdaptor();
    private static final FloatAdaptor FLOAT_ADAPTOR = new FloatAdaptor();
    private static final ByteAdaptor BYTE_ADAPTOR = new ByteAdaptor();
    private static final BigDecimalAdaptor BIGDECIMAL_ADAPTOR = new BigDecimalAdaptor();
    private static final TimeAdaptor TIME_ADAPTOR = new TimeAdaptor();
    private static final UtilDateSqlAdaptor UTILDATESQL_ADAPTOR = new UtilDateSqlAdaptor();
    private static final DateTimeSqlAdaptor DATETIMESQL_ADAPTOR = new DateTimeSqlAdaptor();
    private static final BooleanAdaptor BOOLEAN_ADAPTOR = new BooleanAdaptor();
    private static final DefaultAdaptorMap<?, ?> adaptorMap = new DefaultAdaptorMap();

    @Override
    public BindingAdaptor chooseAdaptor(Method method, Class columnClass) {
        if (AdaptorRegistry.containsKey(method)) {
            return AdaptorRegistry.get(method);
        }
        Class<?> returnType = method.getReturnType();
        BindingAdaptor adaptor = returnType.equals(Integer.TYPE) || returnType.equals(Integer.class) ? INTEGER_ADAPTOR : (returnType.equals(Long.TYPE) || returnType.equals(Long.class) ? LONG_ADAPTOR : (returnType.equals(Character.TYPE) || returnType.equals(Character.class) ? CHAR_ADAPTOR : (returnType.equals(Double.TYPE) || returnType.equals(Double.class) ? DOUBLE_ADAPTOR : (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class) ? BOOLEAN_ADAPTOR : (returnType.equals(Byte.TYPE) || returnType.equals(Byte.class) ? BYTE_ADAPTOR : (returnType.equals(Time.class) ? TIME_ADAPTOR : (returnType.equals(Float.TYPE) || returnType.equals(Float.class) ? FLOAT_ADAPTOR : (returnType.equals(BigDecimal.class) ? BIGDECIMAL_ADAPTOR : (java.util.Date.class.isAssignableFrom(returnType) ? UTILDATESQL_ADAPTOR : (Date.class.equals((Object)columnClass) || Timestamp.class.equals((Object)columnClass) && returnType.equals(DateTime.class) ? DATETIMESQL_ADAPTOR : DEFAULT_ADAPTOR))))))))));
        return adaptor;
    }

    public static DefaultAdaptorMap<?, ?> getInstance() {
        return adaptorMap;
    }
}

