/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.sql;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.pojava.exception.ReflectionException;
import org.pojava.lang.Binding;
import org.pojava.persistence.sql.AdaptorMap;
import org.pojava.persistence.sql.DefaultAdaptorMap;
import org.pojava.persistence.sql.TableMap;
import org.pojava.transformation.BindingAdaptor;
import org.pojava.util.ReflectionTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMap<POJO, PROP, COL> {
    private String property;
    private String columnName;
    private boolean keyField;
    private Class<PROP> propertyClass;
    private Class<COL> columnClass;
    private BindingAdaptor<PROP, COL> adaptor;
    private Method[] getters;
    private Method[] setters;
    private TableMap<POJO> tableMap;

    public FieldMap() {
        this.adaptor = null;
    }

    public FieldMap(String property, String fieldName, boolean isKeyField, Class<COL> columnClass, TableMap<POJO> tableMap) throws NoSuchMethodException {
        Class<POJO> parentType = tableMap.getJavaClass();
        this.property = property;
        this.columnName = fieldName;
        this.keyField = isKeyField;
        this.getters = ReflectionTool.getterMethodDrilldown(parentType, (String)property);
        this.setters = ReflectionTool.setterMethodDrilldown((Method[])this.getters);
        this.propertyClass = this.getters[this.getters.length - 1].getReturnType();
        this.tableMap = tableMap;
        this.columnClass = columnClass;
        this.adaptor = DefaultAdaptorMap.getInstance().chooseAdaptor(this.getters[this.getters.length - 1], columnClass);
    }

    public FieldMap(String property, String fieldName, boolean isKeyField, TableMap<POJO> tableMap, Class<COL> columnClass, AdaptorMap<PROP, COL> adaptorMap) throws NoSuchMethodException {
        Class<POJO> parentType = tableMap.getJavaClass();
        this.property = property;
        this.columnName = fieldName;
        this.keyField = isKeyField;
        this.getters = ReflectionTool.getterMethodDrilldown(parentType, (String)property);
        this.setters = ReflectionTool.setterMethodDrilldown((Method[])this.getters);
        this.propertyClass = this.getters[this.getters.length - 1].getReturnType();
        this.tableMap = tableMap;
        this.columnClass = columnClass;
        this.adaptor = adaptorMap.chooseAdaptor(this.getters[this.getters.length - 1], this.propertyClass);
    }

    public FieldMap(String property, String fieldName, boolean isKeyField, BindingAdaptor<PROP, COL> adaptor, TableMap<POJO> tableMap) throws NoSuchMethodException {
        Class<POJO> parentType = tableMap.getJavaClass();
        this.property = property;
        this.columnName = fieldName;
        this.keyField = isKeyField;
        this.getters = ReflectionTool.getterMethodDrilldown(parentType, (String)property);
        this.setters = ReflectionTool.setterMethodDrilldown((Method[])this.getters);
        this.propertyClass = adaptor.inboundType();
        this.tableMap = tableMap;
        this.columnClass = adaptor.outboundType();
        this.adaptor = adaptor;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Class<COL> getColumnClass() {
        return this.columnClass;
    }

    public void setColumnClass(Class<COL> columnClass) {
        this.columnClass = columnClass;
    }

    public boolean isKeyField() {
        return this.keyField;
    }

    public void setKeyField(boolean keyField) {
        this.keyField = keyField;
    }

    public Class<PROP> getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyClass(Class<PROP> propertyClass) {
        this.propertyClass = propertyClass;
    }

    public void setPropertyValue(ResultSet rs, int column, Object obj) throws SQLException {
        Object value = rs.getObject(column);
        if (this.adaptor != null) {
            value = this.adaptor.inbound(new Binding(this.getColumnClass(), value)).getObj();
        }
        try {
            ReflectionTool.setNestedValue((Method[])this.getters, (Method[])this.setters, (Object)obj, (Object)value);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException("Failed to set value for " + this.getProperty(), (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new ReflectionException("Failed to set value for " + this.getProperty(), (Throwable)ex);
        }
    }

    public Method[] getGetters() {
        return this.getters;
    }

    public void setGetters(Method[] getters) {
        this.getters = getters;
    }

    public Method[] getSetters() {
        return this.setters;
    }

    public void setSetters(Method[] setters) {
        this.setters = setters;
    }

    public BindingAdaptor<PROP, COL> getAdaptor() {
        return this.adaptor;
    }

    public void setAdaptor(BindingAdaptor<PROP, COL> adaptor) {
        this.adaptor = adaptor;
    }

    public void setTableMap(TableMap<POJO> map) {
        this.tableMap = map;
    }

    public TableMap<POJO> getTableMap() {
        return this.tableMap;
    }
}

