/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.pojava.exception.InconceivableException;
import org.pojava.exception.PersistenceException;
import org.pojava.lang.Binding;
import org.pojava.lang.BoundString;
import org.pojava.lang.UncheckedBinding;
import org.pojava.persistence.sql.DatabaseCache;
import org.pojava.persistence.sql.FieldMap;
import org.pojava.persistence.util.SqlTool;
import org.pojava.transformation.BindingAdaptor;
import org.pojava.util.ReflectionTool;
import org.pojava.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMap<POJO> {
    List<FieldMap<POJO, ?, ?>> keyFields = new ArrayList();
    List<FieldMap<POJO, ?, ?>> nonKeyFields = new ArrayList();
    Map<String, FieldMap<POJO, ?, ?>> allFields = new HashMap();
    Class<POJO> javaClass = null;
    String tableName = null;
    String dataSourceName = null;
    Logger logger = Logger.getLogger("persistence.TableMap");

    public TableMap(Class<POJO> javaClass, String tableName, String dataSourceName) {
        if (javaClass == null) {
            throw new IllegalArgumentException("Null javaClass not allowed in TableMap.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Null tableName not allowed in TableMap.");
        }
        if (dataSourceName == null) {
            throw new IllegalArgumentException("Null dataSourceName not allowed in TableMap.");
        }
        this.javaClass = javaClass;
        this.tableName = tableName;
        this.dataSourceName = dataSourceName;
    }

    private Set<String> primaryKeys(Connection conn) throws SQLException {
        ResultSet rs = conn.getMetaData().getPrimaryKeys(null, null, this.tableName);
        HashSet<String> keys = new HashSet<String>();
        while (rs.next()) {
            keys.add(rs.getString(4));
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoBind() throws SQLException {
        DataSource ds = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            ds = DatabaseCache.getDataSource(this.dataSourceName);
            conn = ds.getConnection();
            sql.append("select * from ");
            sql.append(this.tableName);
            sql.append(" where 1=0");
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            ResultSetMetaData dtMeta = rs.getMetaData();
            this.autoBind(conn, dtMeta);
        }
        catch (Throwable throwable) {
            SqlTool.close(rs, stmt, conn);
            throw throwable;
        }
        SqlTool.close(rs, stmt, conn);
    }

    private void autoBind(Connection conn, ResultSetMetaData rsMeta) throws SQLException {
        Set<String> primaryKeys = this.primaryKeys(conn);
        int cols = rsMeta.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            int column = i + 1;
            String fieldName = rsMeta.getColumnName(column);
            String property = StringTool.camelFromUnderscore((String)fieldName);
            FieldMap fm = null;
            try {
                fm = new FieldMap(property, fieldName, primaryKeys.contains(fieldName), Class.forName(rsMeta.getColumnClassName(column)), this);
            }
            catch (NoSuchMethodException ex) {
                throw new InconceivableException("Did reflection find something that doesn't exist?", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                throw new InconceivableException("Weird.  A class returned by MetaData is not in classpath: " + rsMeta.getColumnClassName(column), (Throwable)ex);
            }
            try {
                this.addFieldMap(fm);
                continue;
            }
            catch (NoSuchMethodException ex) {
                this.logger.info("TableMap.autoBind cannot find property to match fieldName=" + fieldName);
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class<POJO> getJavaClass() {
        return this.javaClass;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public List<FieldMap<POJO, ?, ?>> getKeyFields() {
        return this.keyFields;
    }

    public List<FieldMap<POJO, ?, ?>> getNonKeyFields() {
        return this.nonKeyFields;
    }

    public Map<String, FieldMap<POJO, ?, ?>> getAllFields() {
        return this.allFields;
    }

    public void addFieldMap(FieldMap<POJO, ?, ?> field) throws NoSuchMethodException {
        if (field.getGetters() == null) {
            field.setGetters(ReflectionTool.getterMethodDrilldown(this.javaClass, (String)field.getProperty()));
        }
        if (field.getSetters() == null && field.getGetters() != null) {
            field.setSetters(ReflectionTool.setterMethodDrilldown((Method[])field.getGetters()));
        }
        field.setTableMap(this);
        this.allFields.put(field.getProperty(), field);
        if (field.isKeyField()) {
            this.keyFields.add(field);
        } else {
            this.nonKeyFields.add(field);
        }
    }

    public void addFieldMap(String property, String fieldName, boolean isKeyField, Class<Object> columnClass) throws NoSuchMethodException {
        this.addFieldMap(new FieldMap(property, fieldName, isKeyField, columnClass, this));
    }

    public void addFieldMap(String property, String fieldName, boolean isKeyField, BindingAdaptor<Object, Object> adaptor) throws NoSuchMethodException {
        this.addFieldMap(new FieldMap(property, fieldName, isKeyField, adaptor, this));
    }

    private String csvAllFields() {
        StringBuffer sb = new StringBuffer();
        for (FieldMap<POJO, ?, ?> fieldMap : this.allFields.values()) {
            sb.append(fieldMap.getColumnName());
            sb.append(", ");
        }
        sb.setLength(Math.max(0, sb.length() - 2));
        return sb.toString();
    }

    private Object getFieldValue(FieldMap<POJO, ?, ?> field, POJO bean) throws NoSuchMethodException {
        Object propertyObj;
        if (field.getProperty().indexOf(91) >= 0) {
            propertyObj = ReflectionTool.getNestedValue((String)field.getProperty(), bean);
        } else {
            Method[] getters = field.getGetters();
            if (getters == null) {
                getters = ReflectionTool.getterMethodDrilldown(bean.getClass(), (String)field.getProperty());
                field.setGetters(getters);
            }
            propertyObj = ReflectionTool.getNestedValue((Method[])field.getGetters(), bean);
        }
        return propertyObj;
    }

    public BoundString sqlSelect() {
        BoundString bs = new BoundString();
        if (this.keyFields.isEmpty()) {
            throw new IllegalStateException("At least one key field must be defined for table " + this.getTableName());
        }
        bs.append("SELECT ");
        bs.append(this.csvAllFields());
        bs.append(" FROM ");
        bs.append(this.tableName);
        return bs;
    }

    public BoundString sqlSelect(POJO bean) {
        BoundString bs = new BoundString();
        if (this.keyFields.isEmpty()) {
            throw new IllegalStateException("At least one key field must be defined for table " + this.getTableName());
        }
        bs.append("SELECT ");
        bs.append(this.csvAllFields());
        bs.append(" FROM ");
        bs.append(this.tableName);
        bs.append(this.whereKeyFieldsMatch(bean));
        return bs;
    }

    public BoundString sqlInsert(POJO bean) {
        BoundString bs = new BoundString();
        bs.append("INSERT INTO ");
        bs.append(this.tableName);
        bs.append(" (");
        bs.append(this.csvAllFields());
        bs.append(") VALUES (");
        try {
            for (FieldMap<POJO, ?, ?> field : this.allFields.values()) {
                bs.append("?, ");
                bs.getBindings().add(field.getAdaptor().outbound(new Binding(field.getPropertyClass(), this.getFieldValue(field, bean))));
            }
        }
        catch (NoSuchMethodException ex) {
            throw new PersistenceException("Bad FieldMap mapping somehow squeaked through. " + ex.getMessage(), (Throwable)ex);
        }
        bs.chop(2);
        bs.append(")");
        return bs;
    }

    public BoundString sqlUpdate(POJO bean) {
        BoundString bs = new BoundString();
        bs.append("UPDATE ");
        bs.append(this.tableName);
        bs.append(" SET ");
        for (FieldMap<POJO, ?, ?> field : this.nonKeyFields) {
            Method[] getters = field.getGetters();
            Object propertyObj = null;
            bs.append(field.getColumnName());
            bs.append("=?, ");
            if (getters == null) {
                if (field.getProperty().indexOf(91) >= 0) {
                    propertyObj = ReflectionTool.getNestedValue((String)field.getProperty(), bean);
                } else {
                    try {
                        getters = ReflectionTool.getterMethodDrilldown(bean.getClass(), (String)field.getProperty());
                    }
                    catch (NoSuchMethodException ex) {
                        throw new PersistenceException("Bad FieldMap mapping somehow squeaked through. " + ex.getMessage(), (Throwable)ex);
                    }
                    field.setGetters(getters);
                    propertyObj = ReflectionTool.getNestedValue((Method[])field.getGetters(), bean);
                }
            } else {
                propertyObj = ReflectionTool.getNestedValue((Method[])field.getGetters(), bean);
            }
            bs.addBinding((UncheckedBinding)field.getAdaptor().outbound(new Binding(field.getPropertyClass(), propertyObj)));
        }
        bs.chop(2);
        bs.append(this.whereKeyFieldsMatch(bean));
        return bs;
    }

    public BoundString sqlDelete(POJO bean) {
        BoundString bs = new BoundString();
        bs.append("DELETE FROM ");
        bs.append(this.tableName);
        bs.append(this.whereKeyFieldsMatch(bean));
        return bs;
    }

    public BoundString whereKeyFieldsMatch(POJO bean) {
        BoundString bs = new BoundString();
        bs.append(" WHERE ");
        for (FieldMap<POJO, ?, ?> field : this.keyFields) {
            bs.append(field.getColumnName());
            Object propertyObj = null;
            propertyObj = field.getGetters() == null ? ReflectionTool.getNestedValue((String)field.getProperty(), bean) : ReflectionTool.getNestedValue((Method[])field.getGetters(), bean);
            if (propertyObj == null) {
                bs.append(" IS NULL AND ");
                continue;
            }
            bs.append("=? AND ");
            UncheckedBinding ub = new UncheckedBinding(field.getPropertyClass(), propertyObj);
            bs.addBinding(ub);
        }
        bs.chop(5);
        return bs;
    }

    public POJO extractObject(ResultSet rs) {
        POJO obj = null;
        try {
            obj = this.javaClass.newInstance();
            int i = 0;
            for (FieldMap<Object, ?, ?> fieldMap : this.allFields.values()) {
                fieldMap.setPropertyValue(rs, ++i, obj);
            }
        }
        catch (InstantiationException ex) {
            StringBuffer sb = new StringBuffer();
            sb.append("Cannot construct ");
            sb.append(this.javaClass.getName());
            sb.append(": ");
            sb.append(ex.getMessage());
            throw new PersistenceException(sb.toString(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            StringBuffer sb = new StringBuffer();
            sb.append("Cannot construct ");
            sb.append(this.javaClass.getName());
            sb.append(": ");
            sb.append(ex.getMessage());
            throw new PersistenceException(sb.toString(), (Throwable)ex);
        }
        catch (SQLException ex) {
            StringBuffer sb = new StringBuffer();
            sb.append("SQL error while constructing ");
            sb.append(this.javaClass.getName());
            sb.append(": ");
            sb.append(ex.getMessage());
            throw new PersistenceException(sb.toString(), (Throwable)ex);
        }
        return obj;
    }
}

