/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pojava.exception.PersistenceException;
import org.pojava.lang.BoundString;
import org.pojava.lang.Processor;
import org.pojava.persistence.processor.ResultSetToInt;
import org.pojava.persistence.processor.ResultSetToList;
import org.pojava.persistence.processor.ResultSetToProcessor;
import org.pojava.persistence.query.PreparedSql;
import org.pojava.persistence.query.SqlQuery;
import org.pojava.persistence.sql.FieldMap;
import org.pojava.persistence.sql.TableMap;
import org.pojava.persistence.util.SqlTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoTool {
    private static int DEFAULT_MAXROWS = 0;

    private static <T> void validateParamsQuery(TableMap<T> map, SqlQuery query, String action) {
        if (query == null) {
            throw new IllegalArgumentException("Cannot perform " + action + " using a null query.");
        }
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform " + action + " because TableMap is null.");
        }
    }

    private static final <T> void validateParamsList(TableMap<T> map, List<T> obj, String action) {
        if (obj == null) {
            StringBuffer msg = new StringBuffer();
            msg.append("Cannot perform ");
            msg.append(action);
            msg.append(" on null list.");
            throw new IllegalArgumentException(msg.toString());
        }
        if (map == null) {
            StringBuffer msg = new StringBuffer();
            msg.append("Cannot perform ");
            msg.append(action);
            msg.append(" because TableMap is null.");
            throw new IllegalArgumentException(msg.toString());
        }
    }

    private static final <T> void validateParams(TableMap<T> map, T obj, String action) {
        if (obj == null) {
            StringBuffer msg = new StringBuffer();
            msg.append("Cannot perform ");
            msg.append(action);
            msg.append(" on null Object.");
            throw new IllegalArgumentException(msg.toString());
        }
        if (map == null) {
            StringBuffer msg = new StringBuffer();
            msg.append("Cannot perform ");
            msg.append(action);
            msg.append(" because TableMap is null.");
            throw new IllegalArgumentException(msg.toString());
        }
        if (!(obj instanceof List) && !obj.getClass().isAssignableFrom(map.getJavaClass())) {
            StringBuffer msg = new StringBuffer();
            msg.append("Cannot perform ");
            msg.append(action);
            msg.append(" because TableMap.javaClass=");
            msg.append(map.getJavaClass().getName());
            msg.append(" is not equivalent to Object.class=");
            msg.append(obj.getClass().getName());
            throw new IllegalArgumentException(msg.toString());
        }
    }

    public static final <T> int insert(Connection conn, TableMap<T> map, T obj) {
        DaoTool.validateParams(map, obj, "insert");
        try {
            PreparedSql query = new PreparedSql(map.sqlInsert(obj), DEFAULT_MAXROWS);
            return SqlTool.executeUpdate(query, conn);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static final <T> int[] batchInsert(Connection conn, TableMap<T> map, List<T> list) {
        int[] nArray;
        PreparedStatement pstmt = null;
        DaoTool.validateParamsList(map, list, "batchInsert");
        if (list == null || list.size() == 0) {
            return new int[0];
        }
        T obj2 = list.get(0);
        try {
            BoundString sql = map.sqlInsert(obj2);
            pstmt = conn.prepareStatement(sql.getString());
            for (T obj2 : list) {
                sql = map.sqlInsert(obj2);
                SqlTool.prepareBindings(pstmt, sql.getBindings());
                pstmt.addBatch();
            }
            int[] statuses = pstmt.executeBatch();
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i] != -2) continue;
                statuses[i] = 1;
            }
            nArray = statuses;
        }
        catch (SQLException ex) {
            try {
                throw new PersistenceException(ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                SqlTool.close(pstmt);
                throw throwable;
            }
        }
        SqlTool.close(pstmt);
        return nArray;
    }

    public static final <T> int updateInsert(Connection conn, TableMap<T> map, T obj) {
        DaoTool.validateParams(map, obj, "updateInsert");
        int ct = DaoTool.update(conn, map, obj);
        if (ct == 0) {
            ct = DaoTool.insert(conn, map, obj);
        }
        return ct;
    }

    public static final <T> int passiveInsert(Connection conn, TableMap<T> map, T obj) {
        DaoTool.validateParams(map, obj, "passiveInsert");
        if (null == DaoTool.find(conn, map, obj)) {
            return DaoTool.insert(conn, map, obj);
        }
        return 0;
    }

    public static final <T> int update(Connection conn, TableMap<T> map, T obj) {
        DaoTool.validateParams(map, obj, "update");
        try {
            PreparedSql query = new PreparedSql(map.sqlUpdate(obj), DEFAULT_MAXROWS);
            return SqlTool.executeUpdate(query, conn);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static final <T> int delete(Connection conn, TableMap<T> map, T obj) {
        DaoTool.validateParams(map, obj, "delete");
        try {
            PreparedSql query = new PreparedSql(map.sqlDelete(obj), DEFAULT_MAXROWS);
            return SqlTool.executeUpdate(query, conn);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static final <T> T find(Connection conn, TableMap<T> map, T obj) {
        DaoTool.validateParams(map, obj, "find");
        try {
            PreparedSql query = new PreparedSql(map.sqlSelect(obj), DEFAULT_MAXROWS);
            ArrayList list = new ArrayList();
            ResultSetToList<T> processor = new ResultSetToList<T>(map, list);
            int ct = SqlTool.executeQuery(query, conn, processor);
            if (ct == 0) {
                return null;
            }
            if (ct == 1) {
                return (T)list.get(0);
            }
            StringBuffer msg = new StringBuffer();
            msg.append("Data integrity violation.  TableMap for class=");
            msg.append(map.getJavaClass().getName());
            msg.append(", table=");
            msg.append(map.getTableName());
            msg.append(" specifies key fields of (");
            Iterator<FieldMap<T, ?, ?>> it = map.getKeyFields().iterator();
            while (it.hasNext()) {
                String key = it.next().getColumnName();
                msg.append(key);
                msg.append(", ");
            }
            msg.setLength(msg.length() - 2);
            msg.append(") but duplicates exist in database.");
            throw new IllegalStateException(msg.toString());
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static final <T> List<T> listByQuery(Connection conn, TableMap<T> map, SqlQuery query) {
        DaoTool.validateParamsQuery(map, query, "listByQuery");
        try {
            PreparedSql sql = query.generatePreparedSql(map.sqlSelect());
            ArrayList list = new ArrayList();
            ResultSetToList<T> processor = new ResultSetToList<T>(map, list);
            SqlTool.executeQuery(sql, conn, processor);
            return list;
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static final <T> int processByQuery(Connection conn, TableMap<T> map, SqlQuery query, Processor<T> objProcessor) {
        DaoTool.validateParamsQuery(map, query, "processByQuery");
        try {
            ResultSetToProcessor<T> processor = new ResultSetToProcessor<T>(map, objProcessor);
            return SqlTool.executeQuery(query.generatePreparedSql(map.sqlSelect()), conn, processor);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static final <T> int countByQuery(Connection conn, TableMap<T> map, SqlQuery query) {
        try {
            if (query == null) {
                StringBuffer msg = new StringBuffer();
                msg.append("Cannot perform countByQuery using a null query.");
                throw new IllegalArgumentException(msg.toString());
            }
            PreparedSql sql = query.generatePreparedSql("SELECT COUNT(*) FROM " + map.getTableName());
            ResultSetToInt processor = new ResultSetToInt();
            return SqlTool.executeQuery(sql, conn, processor);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static final <T> int deleteByQuery(Connection conn, TableMap<T> map, SqlQuery query) {
        try {
            if (query == null) {
                StringBuffer msg = new StringBuffer();
                msg.append("Cannot perform deleteQuery using a null query.");
                throw new IllegalArgumentException(msg.toString());
            }
            PreparedSql sql = query.generatePreparedSql("DELETE FROM " + map.getTableName());
            return SqlTool.executeUpdate(sql, conn);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }
}

