/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.pojava.datetime.DateTime;
import org.pojava.exception.InitializationException;
import org.pojava.exception.PersistenceException;
import org.pojava.lang.BoundString;
import org.pojava.lang.UncheckedBinding;
import org.pojava.persistence.jndi.DriverManagerDataSource;
import org.pojava.persistence.processor.ResultSetProcessor;
import org.pojava.persistence.processor.ResultSetToInt;
import org.pojava.persistence.query.PreparedSql;
import org.pojava.persistence.sql.TableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTool {
    private static Logger logger = Logger.getLogger("org.pojava.persistence.util.SqlTool");

    public static int executeUpdate(PreparedSql query, Connection conn) throws SQLException {
        PreparedStatement pstmt = SqlTool.generatePreparedStatement(query, conn);
        int result = pstmt.executeUpdate();
        pstmt.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeQuery(PreparedSql query, Connection conn, ResultSetProcessor processor) throws SQLException {
        int n;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int result;
            pstmt = SqlTool.generatePreparedStatement(query, conn);
            rs = pstmt.executeQuery();
            n = result = processor.process(rs);
        }
        catch (Throwable throwable) {
            SqlTool.close(rs, pstmt);
            throw throwable;
        }
        SqlTool.close(rs, pstmt);
        return n;
    }

    public static final int intQuery(Connection conn, PreparedSql query) {
        try {
            if (query == null) {
                StringBuffer msg = new StringBuffer();
                msg.append("Cannot perform intQuery using a null query.");
                throw new IllegalArgumentException(msg.toString());
            }
            ResultSetToInt processor = new ResultSetToInt();
            return SqlTool.executeQuery(query, conn, processor);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static PreparedStatement generatePreparedStatement(PreparedSql preparedSql, Connection conn) throws SQLException {
        BoundString bs = preparedSql.getSql();
        PreparedStatement pstmt = conn.prepareStatement(bs.getString());
        SqlTool.prepareBindings(pstmt, bs.getBindings());
        pstmt.setMaxRows(preparedSql.getMaxRows());
        return pstmt;
    }

    public static void prepareBindings(PreparedStatement pstmt, List<UncheckedBinding> list) throws SQLException {
        int i = 0;
        Iterator<UncheckedBinding> it = list.iterator();
        while (it.hasNext()) {
            ++i;
            UncheckedBinding binding = it.next();
            int sqlType = SqlTool.sqlTypeFromClass(binding.getType());
            Object o = binding.getObj();
            if (o == null) {
                pstmt.setNull(i, sqlType);
                continue;
            }
            pstmt.setObject(i, o, sqlType);
        }
    }

    private static int sqlTypeFromClass(Class<?> c) {
        int type = 0;
        type = c.equals(Integer.class) || c.equals(Integer.TYPE) ? 4 : (c.equals(Long.class) || c.equals(Long.TYPE) ? -5 : (c.equals(Boolean.class) || c.equals(Boolean.TYPE) ? -7 : (c.equals(Character.class) || c.equals(Character.TYPE) ? 1 : (c.equals(Date.class) ? 91 : (c.equals(DateTime.class) || c.equals(java.util.Date.class) || c.equals(Timestamp.class) ? 93 : (c.equals(Double.class) || c.equals(Double.TYPE) || c.equals(Float.class) || c.equals(Float.TYPE) || c.equals(BigDecimal.class) ? 2 : (c.equals(Time.class) ? 92 : (c.equals(Byte.class) || c.equals(Byte.TYPE) ? -6 : 12))))))));
        return type;
    }

    private static InitializationException initializationException(SQLException ex, Class<?> javaClass, String tableName, String dsName) {
        StringBuffer msg = new StringBuffer();
        msg.append("Cannot auto-initialize TableMap(");
        msg.append(javaClass.toString());
        msg.append(",");
        msg.append(tableName);
        msg.append(",");
        msg.append(dsName);
        msg.append("): ");
        msg.append(ex.getMessage());
        return new InitializationException(msg.toString(), (Throwable)ex);
    }

    public static <POJO> TableMap<POJO> autoGenerateTableMap(Class<POJO> javaClass, String tableName, String dsName) {
        try {
            TableMap<POJO> tableMap = new TableMap<POJO>(javaClass, tableName, dsName);
            tableMap.autoBind();
            return tableMap;
        }
        catch (SQLException ex) {
            throw SqlTool.initializationException(ex, javaClass, tableName, dsName);
        }
    }

    public static void close(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void close(ResultSet rs, Statement stmt, Connection conn) {
        PersistenceException pex = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            pex = new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            pex = new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException ex) {
            pex = new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
        if (pex != null) {
            throw pex;
        }
    }

    public static void close(ResultSet rs, Statement stmt) {
        PersistenceException pex = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            pex = new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            pex = new PersistenceException(ex.getMessage(), (Throwable)ex);
        }
        if (pex != null) {
            throw pex;
        }
    }

    public static void close(Connection conn) throws SQLException {
        if (conn != null) {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties fetchProperties(String propertyFile) {
        Properties dataSourceProps = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertyFile);
            dataSourceProps.load(in);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Could not find a property file named " + propertyFile, ex);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "IOException occurred trying to read config/datastore.properties.", ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "IOException occurred trying to close config/datastore.properties.", ex);
            }
        }
        return dataSourceProps;
    }

    public static void registerDataSource(Properties props, String dsName) throws NamingException, ClassNotFoundException {
        InitialContext ctx = new InitialContext();
        try {
            boolean isRegistered = false;
            String driverClass = dsName + ".driver";
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                String listedClassName = driver.getClass().getName();
                if (!driverClass.equals(listedClassName) && !"org.pojava.persistence.sql.DatabaseDriver".equals(listedClassName)) continue;
                isRegistered = true;
                break;
            }
            if (!isRegistered) {
                Class.forName(props.getProperty(dsName + ".driver"));
            }
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "Could not register " + ex.getMessage(), ex);
        }
        DriverManagerDataSource ds = new DriverManagerDataSource(props.getProperty(dsName + ".url"), props.getProperty(dsName + ".user"), props.getProperty(dsName + ".password"));
        ctx.bind("java:/comp/env/jdbc/" + dsName.trim(), (Object)ds);
    }

    public static DataSource readDataSource(Properties props, String dsName) throws NamingException, ClassNotFoundException {
        Class.forName(props.getProperty(dsName + ".driver"));
        DriverManagerDataSource ds = new DriverManagerDataSource(props.getProperty(dsName + ".url"), props.getProperty(dsName + ".user"), props.getProperty(dsName + ".password"));
        return ds;
    }
}

