/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.persistence.util;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.util.zip.DataFormatException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.pojava.persistence.serial.XmlParser;
import org.pojava.persistence.serial.XmlSerializer;
import org.pojava.util.Compression;
import org.pojava.util.EncodingTool;
import org.pojava.util.EncryptionTool;

public class WebSafe {
    private Compression zipper;
    private XmlParser<Object> parser;
    private XmlSerializer serial;
    private String key;

    public WebSafe(String keyString) throws InvalidKeyException {
        this.key = keyString;
        this.zipper = new Compression();
        this.parser = new XmlParser();
        this.serial = new XmlSerializer();
    }

    public WebSafe(SecretKey key) throws InvalidKeyException {
        this.key = key.getAlgorithm() + " " + EncodingTool.base64Encode((byte[])key.getEncoded());
        this.zipper = new Compression();
        this.parser = new XmlParser();
        this.serial = new XmlSerializer();
    }

    Object stringToObject(String webSafeString) throws DataFormatException, GeneralSecurityException {
        byte[] encrypted = EncodingTool.base64Decode((char[])webSafeString.toCharArray());
        byte[] zipped = EncryptionTool.decrypt((byte[])encrypted, (String)this.key);
        String xml = new String(this.zipper.decompress(zipped));
        return this.parser.parse(xml);
    }

    Object stringToObject(String webSafeString, IvParameterSpec ivps) throws DataFormatException, GeneralSecurityException {
        byte[] encrypted = EncodingTool.base64Decode((char[])webSafeString.toCharArray());
        byte[] zipped = EncryptionTool.decrypt((byte[])encrypted, (String)this.key, (IvParameterSpec)ivps);
        String xml = new String(this.zipper.decompress(zipped));
        return this.parser.parse(xml);
    }

    String objectToString(Object obj) throws GeneralSecurityException {
        String xml = this.serial.toXml(obj);
        byte[] zipped = this.zipper.compress(xml.getBytes());
        byte[] encrypted = EncryptionTool.encrypt((byte[])zipped, (String)this.key);
        StringBuilder encoded = new StringBuilder(EncodingTool.base64Encode((byte[])encrypted));
        int len = encoded.length();
        while (--len > 0 && encoded.charAt(len) == '=') {
            encoded.setLength(len);
        }
        return encoded.toString();
    }

    String objectToString(Object obj, IvParameterSpec ivps) throws GeneralSecurityException {
        String xml = this.serial.toXml(obj);
        byte[] zipped = this.zipper.compress(xml.getBytes());
        byte[] encrypted = EncryptionTool.encrypt((byte[])zipped, (String)this.key, (IvParameterSpec)ivps);
        StringBuilder encoded = new StringBuilder(EncodingTool.base64Encode((byte[])encrypted));
        int len = encoded.length();
        while (--len > 0 && encoded.charAt(len) == '=') {
            encoded.setLength(len);
        }
        return encoded.toString();
    }
}

