/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocationcontrol;

import java.util.regex.Matcher;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationControlAssertionError {
    private static final String AT = "at";
    private static final String ERROR_LOCATION_MARKER = "->";
    private static final String COLON_NEWLINE = ":\n";
    private static final String HERE_TEXT = "here:\n";
    private static final String UNDESIRED_INVOCATION_TEXT = " Undesired invocation:";

    public static void updateErrorMessageForVerifyNoMoreInteractions(AssertionError errorToUpdate) {
        String verifyNoMoreInteractionsInvocation = null;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            if (!stackTraceElement.getClassName().equals(PowerMockito.class.getName()) || !stackTraceElement.getMethodName().equals("verifyNoMoreInteractions")) continue;
            int invocationStackTraceIndex = stackTrace[i + 1].getClassName().equals(PowerMockito.class.getName()) && stackTrace[i + 1].getMethodName().equals("verifyZeroInteractions") ? i + 2 : i + 1;
            verifyNoMoreInteractionsInvocation = stackTrace[invocationStackTraceIndex].toString();
        }
        if (verifyNoMoreInteractionsInvocation == null) {
            return;
        }
        String message = ((Throwable)((Object)errorToUpdate)).getMessage();
        StringBuilder builder = new StringBuilder();
        builder.append(message);
        int indexOfFirstAt = message.indexOf(AT);
        int startOfVerifyNoMoreInteractionsInvocation = indexOfFirstAt + AT.length() + 1;
        int endOfVerifyNoMoreInteractionsInvocation = message.indexOf(10, indexOfFirstAt + AT.length());
        builder.replace(startOfVerifyNoMoreInteractionsInvocation, endOfVerifyNoMoreInteractionsInvocation, verifyNoMoreInteractionsInvocation);
        builder.delete(builder.indexOf("\n", endOfVerifyNoMoreInteractionsInvocation + 1), builder.lastIndexOf("\n"));
        Whitebox.setInternalState((Object)errorToUpdate, (Object)builder.toString(), (Object[])new Object[0]);
    }

    public static void updateErrorMessageForMethodInvocation(AssertionError errorToUpdate) {
        Whitebox.setInternalState((Object)errorToUpdate, (Object)("\n" + InvocationControlAssertionError.changeMessageContent(((Throwable)((Object)errorToUpdate)).getMessage())), (Object[])new Object[0]);
    }

    public static void throwAssertionErrorForNewSubstitutionFailure(AssertionError oldError, Class<?> type) {
        String newSubsitutionClassName = InvocationSubstitute.class.getSimpleName();
        String newSubsitutionClassNameInMockito = newSubsitutionClassName.substring(0, 1).toLowerCase() + newSubsitutionClassName.substring(1);
        String message = ((Throwable)((Object)oldError)).getMessage();
        String newSubsitutionMethodName = InvocationSubstitute.class.getDeclaredMethods()[0].getName();
        message = message.replaceAll(newSubsitutionClassNameInMockito + "." + newSubsitutionMethodName, Matcher.quoteReplacement(type.getName()));
        message = message.replaceAll("method", "constructor");
        throw new AssertionError((Object)InvocationControlAssertionError.changeMessageContent(message));
    }

    private static String changeMessageContent(String message) {
        StringBuilder builder = InvocationControlAssertionError.removeFailureLocations(message);
        InvocationControlAssertionError.removeText(builder, UNDESIRED_INVOCATION_TEXT);
        InvocationControlAssertionError.removeAndReplaceText(builder, HERE_TEXT, ' ');
        InvocationControlAssertionError.removeAndReplaceText(builder, COLON_NEWLINE, ' ');
        String finalMessage = builder.toString().trim();
        return finalMessage;
    }

    private static StringBuilder removeFailureLocations(String message) {
        StringBuilder builder = new StringBuilder();
        builder.append(message);
        int indexOfBeginLocation = builder.indexOf(ERROR_LOCATION_MARKER);
        while (indexOfBeginLocation > 0) {
            int indexOfLocationEnd = builder.indexOf("\n", indexOfBeginLocation);
            builder.delete(indexOfBeginLocation, indexOfLocationEnd < 0 ? builder.length() : indexOfLocationEnd + 1);
            indexOfBeginLocation = builder.indexOf(ERROR_LOCATION_MARKER);
        }
        return builder;
    }

    private static void removeAndReplaceText(StringBuilder builder, String text, char appender) {
        int currentTextIndex = builder.indexOf(text);
        int previousTextIndex = 0;
        boolean isSingleConcat = true;
        while (currentTextIndex > 0) {
            previousTextIndex = currentTextIndex;
            builder.delete(currentTextIndex, currentTextIndex + text.length());
            currentTextIndex = builder.indexOf(text);
            if (InvocationControlAssertionError.isLastFinding(currentTextIndex) && !isSingleConcat) {
                builder.replace(builder.length(), builder.length(), ".");
                continue;
            }
            builder.replace(previousTextIndex, previousTextIndex + 1, String.valueOf(builder.charAt(previousTextIndex)).toLowerCase());
            builder.insert(previousTextIndex, String.valueOf(appender));
            ++currentTextIndex;
            isSingleConcat = false;
        }
    }

    private static boolean isLastFinding(int index) {
        return index < 0;
    }

    private static void removeText(StringBuilder builder, String text) {
        int textIndex = builder.indexOf(text);
        while (textIndex > 0) {
            builder.delete(textIndex, textIndex + text.length());
            textIndex = builder.indexOf(text);
        }
    }
}

