/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocationcontrol;

import java.lang.reflect.Constructor;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.internal.invocationcontrol.InvocationControlAssertionError;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.internal.WhiteboxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockitoNewInvocationControl<T>
implements NewInvocationControl<OngoingStubbing<T>> {
    private final InvocationSubstitute<T> substitute;

    public MockitoNewInvocationControl(InvocationSubstitute<T> substitute) {
        if (substitute == null) {
            throw new IllegalArgumentException("Internal error: substitute cannot be null.");
        }
        this.substitute = substitute;
    }

    public Object invoke(Class<?> type, Object[] args, Class<?>[] sig) throws Exception {
        Constructor constructor = WhiteboxImpl.getConstructor(type, (Class[])sig);
        if (constructor.isVarArgs()) {
            args = (Object[])args[args.length - 1];
        }
        try {
            return this.substitute.performSubstitutionLogic(args);
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.throwAssertionErrorForNewSubstitutionFailure((AssertionError)((Object)e), type);
            return null;
        }
    }

    public OngoingStubbing<T> expectSubstitutionLogic(Object ... arguments) throws Exception {
        return Mockito.when((Object)this.substitute.performSubstitutionLogic(arguments));
    }

    public InvocationSubstitute<T> getSubstitute() {
        return this.substitute;
    }

    public synchronized Object replay(Object ... mocks) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Object verify(Object ... mocks) {
        VerificationMode verificationMode;
        Object mode = MockRepository.getAdditionalState((String)"VerificationMode");
        if (mode != null) {
            if (!(mode instanceof VerificationMode)) throw new IllegalStateException("Internal error. VerificationMode in MockRepository was not of type " + VerificationMode.class.getName() + ".");
            verificationMode = (VerificationMode)mode;
        } else {
            verificationMode = Mockito.times((int)1);
        }
        Mockito.verify(this.substitute, (VerificationMode)verificationMode);
        return null;
    }

    public synchronized Object reset(Object ... mocks) {
        Mockito.reset((Object[])new InvocationSubstitute[]{this.substitute});
        return null;
    }

    public void verifyNoMoreInteractions() {
        try {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.substitute});
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForVerifyNoMoreInteractions((AssertionError)((Object)e));
            throw e;
        }
    }
}

