/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.bufstruct;

import org.rapidoid.buffer.Buf;
import org.rapidoid.bufstruct.BufMap;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.data.BufRange;
import org.rapidoid.util.AbstractMapImpl;
import org.rapidoid.util.MapEntry;
import org.rapidoid.util.SimpleBucket;

public class BufMapImpl<T>
extends AbstractMapImpl<byte[], T>
implements BufMap<T> {
    public BufMapImpl() {
        this(100);
    }

    public BufMapImpl(int capacity) {
        super(capacity, -1);
    }

    private long hash(String key) {
        Bytes bytes = BytesUtil.from(key);
        return this.hash(bytes, BufRange.fromTo(0, bytes.limit()));
    }

    private long hash(Bytes bytes, BufRange key) {
        int prefix = BytesUtil.getIntPrefixOf(bytes, key.start, key.limit());
        return prefix * 17 + key.length * 19 + bytes.get(key.last());
    }

    @Override
    public void put(String key, T value) {
        assert (key.length() >= 1);
        MapEntry route = new MapEntry((Object)key.getBytes(), value);
        long hash = this.hash(key);
        this.entries.put(hash, (Object)route);
    }

    @Override
    public T get(Buf buf, BufRange key) {
        long hash = this.hash(buf.bytes(), key);
        SimpleBucket candidates = this.entries.bucket(hash);
        if (candidates != null) {
            for (int i = 0; i < candidates.size(); ++i) {
                MapEntry route = (MapEntry)candidates.get(i);
                if (!BytesUtil.matches(buf.bytes(), key, (byte[])route.key, true)) continue;
                return (T)route.value;
            }
        }
        return (T)this.defaultValue;
    }

    @Override
    public boolean remove(String key) {
        assert (key.length() >= 1);
        long hash = this.hash(key);
        SimpleBucket bucket = this.entries.bucket(hash);
        if (bucket == null) {
            return false;
        }
        for (int i = 0; i < bucket.size(); ++i) {
            MapEntry route = (MapEntry)bucket.get(i);
            if (!new String((byte[])route.key).equals(key)) continue;
            bucket.delete(i);
            return true;
        }
        return false;
    }
}

