/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net;

import org.rapidoid.RapidoidThing;
import org.rapidoid.config.BasicConfig;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.net.impl.RapidoidHelper;

public class NetworkingParams
extends RapidoidThing {
    private volatile String address;
    private volatile int port;
    private volatile int workers;
    private volatile int bufSizeKB;
    private volatile boolean noDelay;
    private volatile long maxPipeline;
    private volatile boolean syncBufs;
    private volatile boolean blockingAccept;
    private volatile Protocol protocol = null;
    private volatile Class<? extends DefaultExchange<?>> exchangeClass = null;
    private volatile Class<? extends RapidoidHelper> helperClass = RapidoidHelper.class;

    public NetworkingParams(BasicConfig cfg) {
        this.address = (String)cfg.entry("address").or((Object)"0.0.0.0");
        this.port = (Integer)cfg.entry("port").or((Object)8080);
        this.workers = (Integer)cfg.entry("workers").or((Object)Runtime.getRuntime().availableProcessors());
        this.bufSizeKB = (Integer)cfg.entry("bufSizeKB").or((Object)16);
        this.noDelay = (Boolean)cfg.entry("noDelay").or((Object)false);
        this.maxPipeline = ((Integer)cfg.entry("maxPipeline").or((Object)0)).intValue();
        this.syncBufs = (Boolean)cfg.entry("syncBufs").or((Object)true);
        this.blockingAccept = (Boolean)cfg.entry("blockingAccept").or((Object)false);
    }

    public String address() {
        return this.address;
    }

    public NetworkingParams address(String address) {
        this.address = address;
        return this;
    }

    public int port() {
        return this.port;
    }

    public NetworkingParams port(int port) {
        this.port = port;
        return this;
    }

    public int workers() {
        return this.workers;
    }

    public NetworkingParams workers(int workers) {
        this.workers = workers;
        return this;
    }

    public int bufSizeKB() {
        return this.bufSizeKB;
    }

    public NetworkingParams bufSizeKB(int bufSizeKB) {
        this.bufSizeKB = bufSizeKB;
        return this;
    }

    public boolean noDelay() {
        return this.noDelay;
    }

    public NetworkingParams noDelay(boolean noDelay) {
        this.noDelay = noDelay;
        return this;
    }

    public long maxPipeline() {
        return this.maxPipeline;
    }

    public NetworkingParams maxPipeline(long maxPipelineSize) {
        this.maxPipeline = maxPipelineSize;
        return this;
    }

    public boolean syncBufs() {
        return this.syncBufs;
    }

    public NetworkingParams syncBufs(boolean syncBufs) {
        this.syncBufs = syncBufs;
        return this;
    }

    public boolean blockingAccept() {
        return this.blockingAccept;
    }

    public NetworkingParams blockingAccept(boolean blockingAccept) {
        this.blockingAccept = blockingAccept;
        return this;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public NetworkingParams protocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Class<? extends DefaultExchange<?>> exchangeClass() {
        return this.exchangeClass;
    }

    public NetworkingParams exchangeClass(Class<? extends DefaultExchange<?>> exchangeClass) {
        this.exchangeClass = exchangeClass;
        return this;
    }

    public Class<? extends RapidoidHelper> helperClass() {
        return this.helperClass;
    }

    public NetworkingParams helperClass(Class<? extends RapidoidHelper> helperClass) {
        this.helperClass = helperClass;
        return this;
    }
}

