/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.File;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufProvider;
import org.rapidoid.data.BinaryMultiData;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.Data;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.MultiData;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.abstracts.ProtocolContext;
import org.rapidoid.net.impl.DecodedData;
import org.rapidoid.net.impl.DefaultBinaryMultiData;
import org.rapidoid.net.impl.DefaultData;
import org.rapidoid.net.impl.DefaultMultiData;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Resetable;

public abstract class DefaultExchange<T>
extends RapidoidThing
implements ProtocolContext<T>,
BufProvider,
Resetable,
Constants {
    protected Channel conn;
    protected AtomicLong totalWritten = new AtomicLong();
    protected long requestId = 0L;

    public synchronized void reset() {
        this.conn = null;
        this.totalWritten.set(0L);
        this.requestId = 0L;
    }

    public synchronized void setConnection(Channel conn) {
        this.conn = conn;
        this.requestId = conn.requestId();
    }

    @Override
    public String address() {
        return this.conn.address();
    }

    @Override
    public T write(String s) {
        byte[] bytes = s.getBytes();
        this.conn.write(bytes);
        return this.wrote(bytes.length);
    }

    @Override
    public T writeln(String s) {
        byte[] bytes = s.getBytes();
        this.conn.write(bytes);
        this.conn.write(CR_LF);
        return this.wrote(bytes.length + 2);
    }

    @Override
    public T write(byte[] bytes) {
        this.conn.write(bytes);
        return this.wrote(bytes.length);
    }

    @Override
    public T write(byte[] bytes, int offset, int length) {
        this.conn.write(bytes, offset, length);
        return this.wrote(length);
    }

    @Override
    public T write(ByteBuffer buf) {
        int n = buf.remaining();
        this.conn.write(buf);
        return this.wrote(n);
    }

    @Override
    public T write(File file) {
        long size = file.length();
        U.must((size < Integer.MAX_VALUE ? 1 : 0) != 0);
        this.conn.write(file);
        return this.wrote((int)size);
    }

    @Override
    public T writeJSON(Object value) {
        this.conn.writeJSON(value);
        return this.me();
    }

    private T wrote(int count) {
        this.totalWritten.addAndGet(count);
        return this.me();
    }

    @Override
    public T close() {
        this.conn.close();
        return this.me();
    }

    @Override
    public T closeIf(boolean condition) {
        this.conn.closeIf(condition);
        return this.me();
    }

    @Override
    public Buf input() {
        return this.conn.input();
    }

    @Override
    public Buf output() {
        return this.conn.output();
    }

    @Override
    public String readln() {
        return this.conn.readln();
    }

    @Override
    public String readN(int count) {
        return this.conn.readN(count);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.conn.getAddress();
    }

    @Override
    public RapidoidHelper helper() {
        return this.conn.helper();
    }

    @Override
    public long connId() {
        return this.conn.connId();
    }

    protected Data data(BufRange range) {
        return new DefaultData(this, range);
    }

    protected Data decodedData(BufRange range) {
        return new DecodedData(this, range);
    }

    protected MultiData multiData(KeyValueRanges ranges) {
        return new DefaultMultiData(this, ranges);
    }

    protected BinaryMultiData binaryMultiData(KeyValueRanges ranges) {
        return new DefaultBinaryMultiData(this, ranges);
    }

    public Buf buffer() {
        return this.conn.input();
    }

    public long getTotalWritten() {
        return this.totalWritten.get();
    }

    @Override
    public long async() {
        return this.conn.async();
    }

    @Override
    public boolean isAsync() {
        return this.conn.isAsync();
    }

    protected T me() {
        return (T)this;
    }

    @Override
    public long requestId() {
        return this.requestId;
    }
}

