/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import org.rapidoid.cls.Cls;
import org.rapidoid.net.NetworkingParams;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.TCPClient;
import org.rapidoid.net.TCPClientInfo;
import org.rapidoid.net.abstracts.ChannelHolder;
import org.rapidoid.net.impl.AbstractEventLoop;
import org.rapidoid.net.impl.ChannelHolderImpl;
import org.rapidoid.net.impl.ConnState;
import org.rapidoid.net.impl.ConnectionTarget;
import org.rapidoid.net.impl.ExtendedWorker;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.u.U;

public class RapidoidClientLoop
extends AbstractEventLoop<TCPClient>
implements TCPClient,
TCPClientInfo {
    private final NetworkingParams net;
    private final int connections;
    private final boolean autoReconnect;
    private final SSLContext sslContext;
    private volatile ExtendedWorker[] ioWorkers;
    private int currentWorkerInd = 0;

    public RapidoidClientLoop(NetworkingParams net, boolean autoReconnect, int connections, SSLContext sslContext) {
        super("client");
        this.net = net;
        this.autoReconnect = autoReconnect;
        this.connections = connections;
        this.sslContext = sslContext;
    }

    @Override
    protected void doProcessing() {
    }

    @Override
    protected final void beforeLoop() {
        try {
            this.openSockets();
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot open socket!", (Throwable)e);
        }
    }

    private void openSockets() throws IOException {
        int i;
        this.ioWorkers = new ExtendedWorker[this.net.workers()];
        for (i = 0; i < this.ioWorkers.length; ++i) {
            RapidoidHelper helper = (RapidoidHelper)((Object)Cls.newInstance(this.net.helperClass(), (Object[])new Object[]{this.net.exchangeClass()}));
            String workerName = "client" + (i + 1);
            this.ioWorkers[i] = new ExtendedWorker(workerName, helper, this.net, this.sslContext);
            new Thread((Runnable)this.ioWorkers[i], workerName).start();
        }
        for (i = 0; i < this.ioWorkers.length; ++i) {
            this.ioWorkers[i].waitToStart();
        }
    }

    @Override
    public synchronized ChannelHolder connect(String serverHost, int serverPort, Protocol clientProtocol, boolean autoreconnecting, ConnState state) {
        InetSocketAddress addr = new InetSocketAddress(serverHost, serverPort);
        SocketChannel socketChannel = RapidoidClientLoop.openSocket();
        ChannelHolderImpl holder = new ChannelHolderImpl();
        try {
            ExtendedWorker targetWorker = this.ioWorkers[this.currentWorkerInd];
            ConnectionTarget target = new ConnectionTarget(socketChannel, addr, clientProtocol, holder, autoreconnecting, state);
            targetWorker.connect(target);
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot create a TCP client connection!", (Throwable)e);
        }
        this.switchToNextWorker();
        return holder;
    }

    @Override
    public synchronized ChannelHolder[] connect(String serverHost, int serverPort, Protocol clientProtocol, int connectionsN, boolean autoreconnecting, ConnState state) {
        ChannelHolder[] holders = new ChannelHolder[connectionsN];
        for (int i = 0; i < connectionsN; ++i) {
            holders[i] = this.connect(serverHost, serverPort, clientProtocol, autoreconnecting, state);
        }
        return holders;
    }

    private synchronized void switchToNextWorker() {
        ++this.currentWorkerInd;
        if (this.currentWorkerInd == this.ioWorkers.length) {
            this.currentWorkerInd = 0;
        }
    }

    protected static SocketChannel openSocket() {
        try {
            SocketChannel socketChannel = SocketChannel.open();
            if (!socketChannel.isOpen()) {
                throw U.rte((String)"Cannot open socket!");
            }
            return socketChannel;
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot open socket!", (Throwable)e);
        }
    }

    @Override
    public synchronized TCPClient start() {
        new Thread((Runnable)this, "client").start();
        super.start();
        this.connect(this.net.address(), this.net.port(), this.net.protocol(), this.connections, this.autoReconnect, null);
        return this;
    }

    @Override
    public synchronized TCPClient shutdown() {
        this.stopLoop();
        for (ExtendedWorker worker : this.ioWorkers) {
            worker.stopLoop();
        }
        return (TCPClient)super.shutdown();
    }

    @Override
    public TCPClientInfo info() {
        return this;
    }

    @Override
    public long messagesProcessed() {
        long total = 0L;
        for (int i = 0; i < this.ioWorkers.length; ++i) {
            total += this.ioWorkers[i].getMessagesProcessed();
        }
        return total;
    }
}

