/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.tls;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.rapidoid.RapidoidThing;
import org.rapidoid.net.tls.SelfSignedCertInfo;
import org.rapidoid.u.U;
import sun.security.tools.keytool.CertAndKeyGen;
import sun.security.x509.X500Name;

public class SelfSignedCertGen
extends RapidoidThing {
    public static void generate(SelfSignedCertInfo info, String keystore, char[] keystorePassword) throws Exception {
        U.must((boolean)U.notEmpty((String)info.alias()), (String)"The alias must be specified!");
        U.must((info.password() != null ? 1 : 0) != 0, (String)"The password must be specified!");
        CertAndKeyGen certAndKeyGen = new CertAndKeyGen("RSA", "SHA1WithRSA", null);
        certAndKeyGen.generate(info.keysize());
        long validityInSeconds = info.validity() * 24L * 3600L;
        Certificate[] cert = new X509Certificate[]{certAndKeyGen.getSelfCertificate(SelfSignedCertGen.x500Name(info), new Date(), validityInSeconds)};
        KeyStore store = KeyStore.getInstance("JKS");
        if (new File(keystore).exists()) {
            store.load(new FileInputStream(keystore), keystorePassword);
        } else {
            store.load(null, null);
        }
        store.setKeyEntry(info.alias(), certAndKeyGen.getPrivateKey(), info.password(), cert);
        store.store(new FileOutputStream(keystore), keystorePassword);
    }

    private static X500Name x500Name(SelfSignedCertInfo info) throws IOException {
        return new X500Name(info.name(), info.unit(), info.organization(), info.locality(), info.state(), info.country());
    }
}

