/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.tls;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.rapidoid.RapidoidThing;
import org.rapidoid.log.Log;
import org.rapidoid.net.tls.SelfSignedCertGen;
import org.rapidoid.net.tls.SelfSignedCertInfo;
import org.rapidoid.u.U;

public class TLSUtil
extends RapidoidThing {
    public static SSLContext createTrustingContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte((Throwable)e);
        }
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sslContext.init(null, new TrustManager[]{tm}, null);
        }
        catch (KeyManagementException e) {
            throw U.rte((Throwable)e);
        }
        return sslContext;
    }

    public static SSLContext createContext(String keystore, char[] keystorePassword, char[] keyManagerPassword, String truststore, char[] truststorePassword, boolean selfSignedTLS) {
        U.must((boolean)U.notEmpty((String)keystore), (String)"The TLS keystore filename isn't configured!");
        boolean keystoreExists = new File(keystore).exists();
        U.must((keystoreExists || selfSignedTLS ? 1 : 0) != 0, (String)"The keystore '%s' doesn't exist and self-signed certificate generation is disabled!", (Object)keystore);
        try {
            if (!keystoreExists && selfSignedTLS) {
                SelfSignedCertInfo info = new SelfSignedCertInfo();
                info.alias("rapidoid");
                info.password(keystorePassword);
                Log.warn((String)"Keystore doesn't exist, creating a keystore with self-signed certificate", (String)"keystore", (Object)keystore, (String)"alias", (Object)info.alias());
                SelfSignedCertGen.generate(info, keystore, keystorePassword);
            }
            Log.info((String)"Initializing TLS context", (String)"keystore", (Object)keystore, (String)"truststore", (Object)truststore);
            KeyManager[] keyManagers = TLSUtil.initKeyManagers(keystore, keystorePassword, keyManagerPassword);
            TrustManager[] trustManagers = TLSUtil.initTrustManagers(truststore, truststorePassword);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagers, trustManagers, null);
            return context;
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    private static KeyManager[] initKeyManagers(String keystore, char[] keystorePassword, char[] keyManagerPassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(keystore), keystorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, keyManagerPassword);
        return keyManagerFactory.getKeyManagers();
    }

    private static TrustManager[] initTrustManagers(String trustStoreFilename, char[] trustStorePassword) throws Exception {
        if (U.notEmpty((String)trustStoreFilename)) {
            U.notNull((Object)trustStorePassword, (String)"trustStorePassword", (Object[])new Object[0]);
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(new FileInputStream(trustStoreFilename), trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(trustStore);
            return trustManagerFactory.getTrustManagers();
        }
        return null;
    }
}

