/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Tag;
import org.restlet.util.DateUtils;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variant {
    public static final long UNKNOWN_SIZE = -1L;
    private List<Language> languages = null;
    private MediaType mediaType;
    private CharacterSet characterSet = null;
    private List<Encoding> encodings = null;
    private long size = -1L;
    private Date expirationDate = null;
    private Date modificationDate;
    private Tag tag;
    private Reference identifier;

    public Variant() {
        this(null);
    }

    public Variant(MediaType mediaType) {
        this.mediaType = mediaType;
        this.modificationDate = null;
        this.tag = null;
        this.identifier = null;
    }

    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public List<Encoding> getEncodings() {
        if (this.encodings == null) {
            this.encodings = new WrapperList<Encoding>(){

                @Override
                public void add(int index, Encoding element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    super.add(index, element);
                }

                @Override
                public boolean add(Encoding element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.add(element);
                }

                @Override
                public boolean addAll(Collection<? extends Encoding> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Encoding> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.addAll(elements);
                }

                @Override
                public boolean addAll(int index, Collection<? extends Encoding> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Encoding> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.addAll(index, elements);
                }
            };
        }
        return this.encodings;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public List<Language> getLanguages() {
        if (this.languages == null) {
            this.languages = new WrapperList<Language>(){

                @Override
                public void add(int index, Language element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    super.add(index, element);
                }

                @Override
                public boolean add(Language element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    return super.add(element);
                }

                @Override
                public boolean addAll(Collection<? extends Language> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Language> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    return super.addAll(elements);
                }

                @Override
                public boolean addAll(int index, Collection<? extends Language> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Language> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    return super.addAll(index, elements);
                }
            };
        }
        return this.languages;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public long getSize() {
        return this.size;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setCharacterSet(CharacterSet characterSet) {
        this.characterSet = characterSet;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = DateUtils.unmodifiable(expirationDate);
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = DateUtils.unmodifiable(modificationDate);
    }

    public void setSize(long expectedSize) {
        this.size = expectedSize;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Reference getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Reference identifier) {
        this.identifier = identifier;
    }

    public void setIdentifier(String identifierUri) {
        this.setIdentifier(new Reference(identifierUri));
    }
}

