/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.theme.images;

import java.awt.Color;

public class CompositeColor
extends Color {
    private double mix = 0.0;
    private Color shadowColor;

    public CompositeColor(int base, int shadow) {
        super(base);
        this.shadowColor = new Color(shadow);
    }

    public double getMix() {
        return this.mix;
    }

    public void setMix(double mix) {
        this.mix = mix;
    }

    public Color getMixedColor() {
        return new Color(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    protected int mix(int from, int to) {
        return (int)((double)from * (1.0 - this.mix) + (double)to * this.mix);
    }

    public int getRed() {
        return this.mix(super.getRed(), this.shadowColor.getRed());
    }

    public int getGreen() {
        return this.mix(super.getGreen(), this.shadowColor.getGreen());
    }

    public int getBlue() {
        return this.mix(super.getBlue(), this.shadowColor.getBlue());
    }

    public int getAlpha() {
        return this.mix(super.getAlpha(), this.shadowColor.getAlpha());
    }

    public int getRGB() {
        return super.getRGB();
    }
}

