/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.theme.images;

import java.awt.geom.AffineTransform;
import javax.faces.context.FacesContext;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.renderkit.html.BaseGradient;

public abstract class BaseShadowGradient
extends BaseGradient {
    public static final AffineTransform FLIP_TRANSFORM = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    public static final double RADIUS = 7.5;
    public static final double MARGIN = 5.0;
    protected static final int SHADOW_RADIUS = 12;

    public BaseShadowGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor, boolean horizontal) {
        super(width, height, gradientHeight, baseColor, gradientColor, horizontal);
    }

    public BaseShadowGradient(int width, int height, int gradientHeight) {
        super(width, height, gradientHeight);
    }

    public BaseShadowGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor) {
        super(width, height, gradientHeight, baseColor, gradientColor);
    }

    public BaseShadowGradient(int width, int height) {
        super(width, height);
    }

    public BaseShadowGradient(int width, int height, String baseColor, String gradientColor) {
        super(width, height, baseColor, gradientColor);
    }

    public BaseShadowGradient() {
    }

    public BaseShadowGradient(String baseColor, String gradientColor) {
        super(baseColor, gradientColor);
    }

    public BaseShadowGradient(int width, int height, int gradientHeight, boolean horizontal) {
        super(width, height, gradientHeight, horizontal);
    }

    public BaseShadowGradient(int width, int height, boolean horizontal) {
        super(width, height, horizontal);
    }

    public BaseShadowGradient(int width, int height, String baseColor, String gradientColor, boolean horizontal) {
        super(width, height, baseColor, gradientColor, horizontal);
    }

    public BaseShadowGradient(boolean horizontal) {
        super(horizontal);
    }

    protected String getShadowColor() {
        return "shadowBackgroundColor";
    }

    protected String getBorderColor() {
        return "panelBorderColor";
    }

    protected BaseGradient.Data createData() {
        return new ShadowData();
    }

    protected void saveData(FacesContext context, BaseGradient.Data data, Object parameterData) {
        super.saveData(context, data, parameterData);
        ShadowData d = (ShadowData)data;
        d.setShadowColor(this.getShadowColor(context));
        d.setBorderColor(this.getBorderColor(context));
    }

    protected Integer getShadowColor(FacesContext context) {
        return this.getColorValueParameter(context, this.getShadowColor(), false);
    }

    protected Integer getBorderColor(FacesContext context) {
        return this.getColorValueParameter(context, this.getBorderColor(), false);
    }

    protected void restoreData(BaseGradient.Data data, Zipper2 zipper2) {
        if (zipper2.hasMore()) {
            ((ShadowData)data).setShadowColor(zipper2.nextInt());
            ((ShadowData)data).setBorderColor(zipper2.nextInt());
            super.restoreData(data, zipper2);
        }
    }

    protected AffineTransform createFlipTransform() {
        return new AffineTransform(-1.0, 0.0, 0.0, 1.0, this.getDimensions(null).getWidth(), 0.0);
    }

    public BaseShadowGradient(String baseColor, String gradientColor, boolean horizontal) {
        super(baseColor, gradientColor, horizontal);
    }

    protected static class ShadowData
    extends BaseGradient.Data {
        private Integer shadowColor;
        private Integer borderColor;

        protected ShadowData() {
        }

        protected Integer getShadowColor() {
            return this.shadowColor;
        }

        protected void setShadowColor(Integer shadowColor) {
            this.shadowColor = shadowColor;
        }

        public byte[] toByteArray() {
            byte[] bs = super.toByteArray();
            byte[] result = new byte[(bs != null ? bs.length : 0) + 8];
            new Zipper2(result).addInt(this.shadowColor.intValue()).addInt(this.borderColor.intValue()).addBytes(bs);
            return result;
        }

        protected Integer getBorderColor() {
            return this.borderColor;
        }

        protected void setBorderColor(Integer borderColor) {
            this.borderColor = borderColor;
        }
    }
}

