/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.theme.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import org.richfaces.renderkit.html.BaseGradient;
import org.richfaces.theme.images.BaseShadowGradient;

public class ShadowHeaderBackground
extends BaseShadowGradient {
    public ShadowHeaderBackground() {
        super(15, 95, 80, "headerGradientColor", "headerBackgroundColor", false);
    }

    protected void paintGradient(Graphics2D g2d, BaseGradient.Data data) {
        BaseShadowGradient.ShadowData shadowData = (BaseShadowGradient.ShadowData)data;
        if (null != shadowData.getShadowColor()) {
            GradientPaint gragient = new GradientPaint(0.0f, 0.0f, new Color(shadowData.getHeaderGradientColor()), 0.0f, 10.0f, new Color(shadowData.getShadowColor()));
            g2d.setPaint(gragient);
            g2d.fillRect(0, 0, this.getDimensions(null).width, 5);
        }
        g2d.translate(0.0, 5.0);
        this.paintGradientContent(g2d, data);
    }

    protected void paintGradientContent(Graphics2D g2d, BaseGradient.Data data) {
        Dimension dim = this.getDimensions(null, data);
        super.paintGradient(g2d, data);
        Integer headerBackgroundColor = data.getHeaderBackgroundColor();
        if (headerBackgroundColor != null && dim.height > this.getGradientHeight() && this.getGradientHeight() >= 0) {
            g2d.setPaint(null);
            g2d.setColor(new Color(headerBackgroundColor));
            g2d.fillRect(0, this.getGradientHeight(), dim.width, dim.height);
        }
    }
}

