/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.ImageCacheScript;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIPanelBar;
import org.richfaces.component.UIPanelBarItem;
import org.richfaces.event.SwitchablePanelSwitchEvent;

public abstract class PanelBarRendererBase extends HeaderResourcesRendererBase {

	public static final String PANEL_BAR_RESOURCES = "PANEL_BAR_RESOURCES";
	public static final String EXPANDED_ATTR="expanded";

	private final InternetResource[] scripts = {new AjaxScript(),new PrototypeScript(),new ImageCacheScript(), getResource("/org/richfaces/renderkit/html/scripts/browser_info.js"), getResource("scripts/panelbar.js") };
	
	protected InternetResource[] getScripts() {
		return scripts;
	}
	
	protected Class getComponentClass() {
		return UIPanelBar.class;
	}
	
	public boolean getRendersChildren() {
		return true;
	}

	public String expanded(FacesContext context, UIComponent component) throws IOException {
		UIPanelBar panelbar = (UIPanelBar) component;
		String value = (String)panelbar.getValue();
        ValueBinding valueBinding = panelbar.getValueBinding("selectedPanel");
		if (value != null && valueBinding == null) {
			UIComponent item = component.findComponent(value);
			if (item != null) {
				panelbar.setValue(item.getClientId(context));
				return item.getClientId(context); 
			}
		} else {
            Object selected = panelbar.getSelectedPanel();
            if (selected != null) {
                List items = panelbar.getChildren();
                for(Iterator it = items.iterator();it.hasNext();) {
                    UIComponent comp = (UIComponent)it.next();
                    if (comp instanceof UIPanelBarItem) {
                        UIPanelBarItem item = (UIPanelBarItem) comp;
                        if (item.getName().equals(selected)) {
                            return item.getClientId(context);
                        }
                    } 
                }
            }
        }
		return "";
	}
	
	public String width(FacesContext context, UIComponent component) throws IOException {
		String width = (String) component.getAttributes().get("width");
		if (width == null || width.length() == 0) {
			width = "100%";
		}
		return "width: "+getUtils().encodePctOrPx(width)+";";
	}
	
	public String height(FacesContext context, UIComponent component) throws IOException {
		String height = (String) component.getAttributes().get("height");
		if (height == null || height.length() == 0 || height.equals("100%")) {
			height = "100%";
		}
		return "height: "+getUtils().encodePctOrPx(height)+";";
	}


	public void decode(FacesContext context, UIComponent component) {
		super.decode(context,component);

		Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
		String value = (String)requestParameterMap.get(component.getClientId(context));
		if (value != null) {
			new SwitchablePanelSwitchEvent(component, value, null).queue();
		}
		
/*		Object property=context.getExternalContext().getRequestParameterMap().get(component.getClientId(context));
		if (property!=null){
			component.getAttributes().put(EXPANDED_ATTR,property);
		}*/
	}
	
}
