/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.Column;
import org.richfaces.component.UIScrollableDataTable;
import org.richfaces.component.util.ColumnUtil;
import org.richfaces.event.scroll.ScrollEvent;
import org.richfaces.event.sort.SortEvent;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.html.AjaxFunctionBuilder;
import org.richfaces.renderkit.html.ColumnVisitor;
import org.richfaces.renderkit.html.ColumnWalker;
import org.richfaces.renderkit.html.ExtendedColumnVisitor;
import org.richfaces.renderkit.html.HTMLEncodingContributor;
import org.richfaces.renderkit.html.ScrollableDataTableOptions;
import org.richfaces.renderkit.html.ScrollableDataTableRendererState;
import org.richfaces.renderkit.html.ScrollableDataTableScrollData;
import org.richfaces.renderkit.html.ScrollableDataTableUtils;
import org.richfaces.renderkit.html.SelectionRendererContributor;
import org.richfaces.utils.TemplateLoader;

public abstract class ScrollableDataTableBaseRenderer
extends CompositeRenderer {
    public final String PARTIAL_UPDATE = "partialUpdate";
    public final String UPDATE_HEADER = "updateHeader";
    public final String FOOTER_PART = "footer";
    public final String HEADER_PART = "header";
    private final String COLUMN_FROZEN_TYPE = "frozen";
    private final String COLUMN_NORMAL_TYPE = "normal";
    private RendererBase cellTemplate = null;
    private RendererBase headerCellTemplate = null;
    private RendererBase footerCellTemplate = null;
    private RendererBase headerItselfTemplate = null;
    private final Log log = LogFactory.getLog((Class)(class$org$richfaces$renderkit$html$ScrollableDataTableBaseRenderer == null ? (class$org$richfaces$renderkit$html$ScrollableDataTableBaseRenderer = ScrollableDataTableBaseRenderer.class$("org.richfaces.renderkit.html.ScrollableDataTableBaseRenderer")) : class$org$richfaces$renderkit$html$ScrollableDataTableBaseRenderer));
    private final ColumnVisitor columnsWidthCounter = new ColumnVisitor(){

        public int visit(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            int prevWidth = 0;
            int width = 0;
            String widthPx = (String)column.getAttributes().get("width");
            prevWidth = state.getSumWidth();
            if (widthPx.endsWith("px")) {
                width = prevWidth + Integer.parseInt(widthPx.substring(0, widthPx.indexOf("px")));
            }
            state.setSumWidth(width);
            return 1;
        }
    };
    private final ColumnVisitor colsRenderer = new ExtendedColumnVisitor(){

        public void renderContent(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            writer.startElement("col", column);
            ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "width", column.getAttributes().get("width"));
            ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "style", column.getAttributes().get("style"));
            writer.endElement("col");
        }
    };
    private final ColumnVisitor headerCellRenderer = new ExtendedColumnVisitor(){

        public void renderContent(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            int cell_index = state.getCellIndex();
            String client_id = state.getClientId();
            state.addId(column.getId());
            ScrollableDataTableBaseRenderer.this.headerCellTemplate = ScrollableDataTableBaseRenderer.this.getHeaderCellTemplate();
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)ScrollableDataTableBaseRenderer.this.headerCellTemplate, (UIComponent)column);
            String widthPx = (String)column.getAttributes().get("width");
            int width = Integer.parseInt(widthPx.substring(0, widthPx.indexOf("px")));
            int sepOffset = 0;
            if (state.isFrozenColumn()) {
                sepOffset = state.getSepOffset() + width;
            } else {
                sepOffset = state.getSepOffset() + width + 1;
                state.setSepOffset(new Integer(sepOffset));
            }
            variables.setVariable("client_id", (Object)client_id);
            variables.setVariable("cell_index", (Object)new Integer(cell_index));
            variables.setVariable("sepOffset", (Object)new Integer(sepOffset));
            variables.setVariable("headerColumnClass", (Object)state.getColumnClass());
            Boolean sorting = ScrollableDataTableBaseRenderer.this.getColumnSorting(state.getGrid(), cell_index);
            if (sorting != null) {
                if (sorting.booleanValue()) {
                    variables.setVariable("headerColumnSortClass", (Object)"rich-sdt-header-sort-up");
                } else {
                    variables.setVariable("headerColumnSortClass", (Object)"rich-sdt-header-sort-down");
                }
            }
            ScrollableDataTableBaseRenderer.this.headerCellTemplate.encodeBegin(context, column);
            ScrollableDataTableBaseRenderer.this.headerRenderer.visit(context, column, writer, state);
            ScrollableDataTableBaseRenderer.this.headerCellTemplate.encodeEnd(context, column);
        }
    };
    private final ColumnVisitor headerRenderer = new ColumnVisitor(){

        public int visit(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)ScrollableDataTableBaseRenderer.this.getHeaderItselfTemplate(), (UIComponent)column);
            int cell_index = state.getCellIndex();
            String client_id = state.getClientId();
            Boolean sorting = ScrollableDataTableBaseRenderer.this.getColumnSorting(state.getGrid(), cell_index);
            if (sorting != null) {
                if (sorting.booleanValue()) {
                    variables.setVariable("sortAscending", (Object)Boolean.TRUE);
                } else {
                    variables.setVariable("sortDescending", (Object)Boolean.TRUE);
                }
            }
            variables.setVariable("client_id", (Object)client_id);
            variables.setVariable("cell_index", (Object)new Integer(cell_index));
            ScrollableDataTableBaseRenderer.this.getHeaderItselfTemplate().encodeBegin(context, column);
            UIComponent header = column.getFacet("header");
            if (header != null) {
                ScrollableDataTableBaseRenderer.this.renderChild(context, header);
            }
            ScrollableDataTableBaseRenderer.this.getHeaderItselfTemplate().encodeEnd(context, column);
            return 0;
        }
    };
    private final ColumnVisitor footerCellRenderer = new ExtendedColumnVisitor(){

        public void renderContent(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            UIComponent component;
            int cell_index = state.getCellIndex();
            String client_id = state.getClientId();
            ScrollableDataTableBaseRenderer.this.footerCellTemplate = ScrollableDataTableBaseRenderer.this.getFooterCellTemplate();
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)ScrollableDataTableBaseRenderer.this.footerCellTemplate, (UIComponent)column);
            variables.setVariable("client_id", (Object)client_id);
            variables.setVariable("cell_index", (Object)new Integer(cell_index));
            variables.setVariable("footerColumnClass", (Object)state.getColumnClass());
            Boolean sorting = ScrollableDataTableBaseRenderer.this.getColumnSorting(state.getGrid(), cell_index);
            if (sorting != null) {
                if (sorting.booleanValue()) {
                    variables.setVariable("footerColumnSortClass", (Object)"rich-sdt-footer-sort-up");
                } else {
                    variables.setVariable("footerColumnSortClass", (Object)"rich-sdt-footer-sort-down");
                }
            }
            if ((component = column.getFacet("footer")) != null) {
                ScrollableDataTableBaseRenderer.this.footerCellTemplate.encodeBegin(context, column);
                ScrollableDataTableBaseRenderer.this.renderChild(context, component);
                ScrollableDataTableBaseRenderer.this.footerCellTemplate.encodeEnd(context, column);
            }
        }
    };
    private final ColumnVisitor cellRenderer = new ExtendedColumnVisitor(){

        public void renderContent(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            String cell_id = state.getRowIndex() + "_" + state.getCellIndex();
            if (ScrollableDataTableBaseRenderer.this.log.isTraceEnabled()) {
                ScrollableDataTableBaseRenderer.this.log.trace((Object)("cell_index: " + cell_id));
            }
            String client_id = state.getClientId();
            int cell_index = state.getCellIndex();
            ScrollableDataTableBaseRenderer.this.cellTemplate = ScrollableDataTableBaseRenderer.this.getCellTemplate();
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)ScrollableDataTableBaseRenderer.this.cellTemplate, (UIComponent)column);
            variables.setVariable("cell_id", (Object)cell_id);
            variables.setVariable("client_id", (Object)client_id);
            variables.setVariable("cell_index", (Object)new Integer(cell_index));
            variables.setVariable("columnClass", (Object)state.getColumnClass());
            Boolean sorting = ScrollableDataTableBaseRenderer.this.getColumnSorting(state.getGrid(), cell_index);
            if (sorting != null) {
                if (sorting.booleanValue()) {
                    variables.setVariable("columnSortClass", (Object)"rich-sdt-column-sort-up");
                } else {
                    variables.setVariable("columnSortClass", (Object)"rich-sdt-column-sort-down");
                }
            }
            ScrollableDataTableBaseRenderer.this.cellTemplate.encodeBegin(context, column);
            if (!state.isFake()) {
                ScrollableDataTableBaseRenderer.this.renderChildren(context, column);
            }
            ScrollableDataTableBaseRenderer.this.cellTemplate.encodeEnd(context, column);
        }
    };
    private final DataVisitor rowsRenderer = new DataVisitor(){

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            ScrollableDataTableRendererState state = (ScrollableDataTableRendererState)argument;
            UIScrollableDataTable grid = state.getGrid();
            grid.setRowKey(rowKey);
            if (grid.isRowAvailable() || state.isFake()) {
                int index = state.getRowIndex();
                String baseClientId = grid.getBaseClientId(context);
                String row_id = state.isFrozenPart() ? baseClientId + ":f:" + index : baseClientId + ":n:" + index;
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("tr", (UIComponent)grid);
                state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
                ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "id", (Object)row_id);
                ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)("dr-sdt-rb rich-sdt-row " + state.getRowClass(index)));
                ScrollableDataTableBaseRenderer.this.addRowJavascriptEvents(writer, (UIComponent)grid);
                if (ScrollableDataTableBaseRenderer.this.log.isDebugEnabled()) {
                    ScrollableDataTableBaseRenderer.this.log.debug((Object)("rowIndex : " + index));
                }
                ColumnWalker.iterateOverColumns(context, (UIComponent)grid, ScrollableDataTableBaseRenderer.this.cellRenderer, writer, state);
                if (!state.isFrozenPart()) {
                    writer.startElement("td", (UIComponent)grid);
                    ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)("dr-sdt-bc rich-sdt-row " + state.getColumnClass(state.getCellIndex())));
                    writer.endElement("td");
                }
                writer.endElement("tr");
                state.nextRow();
                state.setCellIndex(0);
            }
        }
    };
    private final DataVisitor ajaxRowsRenderer = new DataVisitor(){

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            int columnsCount = 0;
            boolean frozenTRRendered = false;
            boolean normalTRRendered = false;
            ScrollableDataTableRendererState state = (ScrollableDataTableRendererState)argument;
            AjaxContext ajaxContext = state.getAjaxContext();
            ajaxContext.getResponseData();
            UIScrollableDataTable grid = state.getGrid();
            Collection collection = grid.getResponseData();
            grid.setRowKey(rowKey);
            ResponseWriter writer = context.getResponseWriter();
            state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
            String row_id = null;
            Iterator iter = grid.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent kid = (UIComponent)iter.next();
                if (!kid.isRendered() || !(kid instanceof Column)) continue;
                String baseClientId = grid.getBaseClientId(context);
                if (state.isFrozenColumn() && !frozenTRRendered) {
                    state.setFrozenPart(true);
                    frozenTRRendered = true;
                    row_id = baseClientId + ":f:" + state.getRowIndex();
                    writer.startElement("tr", (UIComponent)grid);
                    ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)("dr-sdt-rb rich-sdt-row" + state.getRowClass(state.getRowIndex())));
                    ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "id", (Object)row_id);
                    ScrollableDataTableBaseRenderer.this.addRowJavascriptEvents(writer, (UIComponent)grid);
                    collection.add(row_id);
                } else if (!state.isFrozenColumn() && !normalTRRendered) {
                    if (frozenTRRendered) {
                        writer.endElement("tr");
                    }
                    state.setFrozenPart(false);
                    row_id = baseClientId + ":n:" + state.getRowIndex();
                    writer.startElement("tr", (UIComponent)grid);
                    ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "id", (Object)row_id);
                    ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)("dr-sdt-rb rich-sdt-row" + state.getRowClass(state.getRowIndex())));
                    ScrollableDataTableBaseRenderer.this.addRowJavascriptEvents(writer, (UIComponent)grid);
                    normalTRRendered = true;
                    collection.add(row_id);
                }
                columnsCount += ScrollableDataTableBaseRenderer.this.cellRenderer.visit(context, kid, writer, state);
                state.nextCell();
            }
            writer.endElement("tr");
            state.setCellIndex(0);
            state.nextRow();
        }
    };
    static /* synthetic */ Class class$org$richfaces$renderkit$html$ScrollableDataTableBaseRenderer;

    public ScrollableDataTableBaseRenderer() {
        this.addContributor(new SelectionRendererContributor());
    }

    public static String getJavaScriptVarName(FacesContext context, UIScrollableDataTable grid) {
        String name = grid.getScriptVar();
        if (name == null) {
            String id = grid.getBaseClientId(context);
            name = "Richfaces_ScrollableGrid_" + id.replaceAll("[^A-Za-z0-9_]", "_");
        }
        return "window." + name;
    }

    public String createClientScrollableGrid(FacesContext context, UIScrollableDataTable grid) {
        ScrollableDataTableOptions options = new ScrollableDataTableOptions(grid);
        this.mergeScriptOptions(options, context, (UIComponent)grid);
        JSFunction function = new JSFunction("new ClientUI.controls.grid.ScrollableGrid");
        function.addParameter((Object)options);
        return function.toScript();
    }

    protected String getScriptContributions(FacesContext context, UIScrollableDataTable grid) {
        return super.getScriptContributions(ScrollableDataTableBaseRenderer.getJavaScriptVarName(context, grid), context, (UIComponent)grid);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void renderGridBody(FacesContext context, UIScrollableDataTable grid, boolean isFrozen) throws IOException {
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        if (isFrozen) {
            state.setColumType("frozen");
        } else {
            state.setColumType("normal");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"ScrollableDataTableBaseRenderer.renderGridBody(context, grid, isFrozen)");
        }
        state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
        state.setFrozenPart(isFrozen);
        state.setClientId(grid.getClientId(context));
        grid.walk(context, this.rowsRenderer, state);
        int fakeRowsCount = grid.getRows() - grid.getRowCount();
        state.setFake(true);
        for (int i = 0; i < fakeRowsCount; ++i) {
            this.rowsRenderer.process(context, null, (Object)state);
        }
        state.setFake(false);
        state.setRowIndex(0);
        grid.setRowKey(null);
    }

    public void renderHeaders(FacesContext context, UIScrollableDataTable grid, boolean isFrozen) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        if (isFrozen) {
            state.setColumType("frozen");
        } else {
            state.setColumType("normal");
        }
        state.setClientId(grid.getClientId(context));
        state.setPart("header");
        state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
        state.setFrozenPart(isFrozen);
        state.setClientId(grid.getClientId(context));
        state.setSepOffset(new Integer(0));
        ColumnWalker.iterateOverColumns(context, (UIComponent)grid, this.headerCellRenderer, writer, state);
    }

    public void renderCols(FacesContext context, UIScrollableDataTable grid, boolean isFrozen) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        if (isFrozen) {
            state.setColumType("frozen");
        } else {
            state.setColumType("normal");
        }
        state.setClientId(grid.getClientId(context));
        state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
        state.setFrozenPart(isFrozen);
        ColumnWalker.iterateOverColumns(context, (UIComponent)grid, this.colsRenderer, writer, state);
    }

    public void renderFooters(FacesContext context, UIScrollableDataTable grid, boolean isFrozen) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        if (isFrozen) {
            state.setColumType("frozen");
        } else {
            state.setColumType("normal");
        }
        state.setClientId(grid.getClientId(context));
        state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
        state.setFrozenPart(isFrozen);
        int colsCount = ColumnWalker.iterateOverColumns(context, (UIComponent)grid, this.footerCellRenderer, writer, state);
        int rowsCount = grid.getRowCount();
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)grid);
        variables.setVariable("rows_count", (Object)new Integer(rowsCount));
        variables.setVariable("columns_count", (Object)new Integer(colsCount));
    }

    public void setUpState(FacesContext context, UIScrollableDataTable grid) {
        ScrollableDataTableRendererState.createState(context, grid);
    }

    public void tearDownState(FacesContext context, UIScrollableDataTable grid) {
        ScrollableDataTableRendererState.restoreState(context);
    }

    public String getRowsAjaxUpdate(FacesContext context, UIScrollableDataTable grid) {
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)grid, (FacesContext)context);
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)grid);
        options.put("oncomplete", AjaxFunctionBuilder.getOnComplete(context, grid, 1));
        Map parametersMap = (Map)options.get("parameters");
        parametersMap.put(grid.getBaseClientId(context) + ":scroll", "");
        function.addParameter((Object)options);
        String completeFunction = function.toScript() + "; return false;";
        return completeFunction;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        component.getAttributes().remove("partialUpdate");
        component.getAttributes().remove("updateHeader");
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (component instanceof UIScrollableDataTable) {
            String s_id;
            UIScrollableDataTable grid = (UIScrollableDataTable)component;
            ExternalContext externalContext = context.getExternalContext();
            String clientId = grid.getClientId(context);
            boolean sorted = false;
            Map parameters = externalContext.getRequestParameterMap();
            if (parameters.containsKey(s_id = clientId + ":si")) {
                String options = (String)parameters.get(s_id);
                grid.setScrollPos(options);
            }
            if (parameters.containsKey(clientId + ":sortColumn") && parameters.containsKey(clientId + ":sortStartRow") && parameters.containsKey(clientId + ":sortIndex") && parameters.containsKey(clientId + ":sortOrder")) {
                int sortColumn = Integer.parseInt((String)parameters.get(clientId + ":sortColumn"));
                int sortDataIndex = Integer.parseInt((String)parameters.get(clientId + ":sortIndex"));
                Integer sortStartRow = Integer.valueOf((String)parameters.get(clientId + ":sortStartRow"));
                Column column = (Column)grid.getChildren().get(sortColumn);
                if (column.isSortable()) {
                    sorted = true;
                    SortEvent sortEvent = new SortEvent((UIComponent)grid, sortColumn, grid.getRows(), sortDataIndex);
                    sortEvent.setAttribute("clientIndex", (Object)sortStartRow);
                    if (ajaxContext.isAjaxRequest()) {
                        sortEvent.setAttribute("partialUpdate", (Object)Boolean.TRUE);
                        sortEvent.setAttribute("updateHeader", (Object)Boolean.TRUE);
                    }
                    sortEvent.queue();
                }
            }
            if (parameters.containsKey(clientId + ":scroll") && !sorted) {
                String submitedState = (String)parameters.get(clientId + "_state_input");
                boolean isEmpty = true;
                String[] values = submitedState.split(",");
                for (int i = 0; i < values.length; ++i) {
                    isEmpty = isEmpty && values[i].equals("");
                }
                int rows = 0;
                int first = 0;
                if (!isEmpty) {
                    rows = Integer.parseInt(values[0]);
                    first = Integer.parseInt(values[1]);
                    ScrollEvent scrollEvent = new ScrollEvent((UIComponent)grid, rows, first);
                    scrollEvent.setAttribute("clientIndex", (Object)Integer.valueOf(values[2]));
                    if (ajaxContext.isAjaxRequest()) {
                        scrollEvent.setAttribute("partialUpdate", (Object)Boolean.TRUE);
                    }
                    scrollEvent.queue();
                }
            }
        }
    }

    public void renderAjaxChildren(FacesContext context, UIComponent component) throws IOException {
        UIScrollableDataTable grid = (UIScrollableDataTable)component;
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.createState(context, grid);
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        String client_id = grid.getClientId(context);
        state.setClientId(client_id);
        state.setAjaxContext(ajaxContext);
        state.setRowIndex(ScrollableDataTableUtils.getClientRowIndex(grid));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ScrollableDataTableBaseRenderer.renderAjaxChildren()");
        }
        grid.getResponseData().clear();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", (UIComponent)grid);
        writer.startElement("tbody", (UIComponent)grid);
        grid.walk(context, this.ajaxRowsRenderer, state);
        writer.endElement("tbody");
        writer.endElement("table");
        ScrollableDataTableRendererState.restoreState(context);
        grid.setRowKey(null);
        ajaxContext.setResponseData((Object)grid.getResponseData());
        ajaxContext.getAjaxRenderedAreas().remove(grid.getClientId(context));
        ScrollableDataTableScrollData options = this.createOptions(grid);
        ajaxContext.getResponseDataMap().put("options", options);
        this.contributorsEncodeHere(context, grid);
        if (this.shouldUpdateHeader(component)) {
            ColumnWalker.iterateOverColumns(context, component, this.headerRenderer, writer, new ScrollableDataTableRendererState(context, null, grid));
        }
    }

    private ScrollableDataTableScrollData createOptions(UIScrollableDataTable grid) {
        int index = grid.getFirst();
        int startRow = ScrollableDataTableUtils.getClientRowIndex(grid);
        int count = grid.getRows() == 0 ? grid.getRowCount() : grid.getRows();
        ScrollableDataTableScrollData options = new ScrollableDataTableScrollData(index, startRow, count);
        return options;
    }

    private boolean onlyPartialUpdateNeeded(UIComponent grid) {
        Boolean b = (Boolean)grid.getAttributes().get("partialUpdate");
        return b != null && b != false && AjaxContext.getCurrentInstance().isAjaxRequest();
    }

    private boolean shouldUpdateHeader(UIComponent grid) {
        Boolean b = (Boolean)grid.getAttributes().get("updateHeader");
        return b != null && b != false && AjaxContext.getCurrentInstance().isAjaxRequest();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (this.onlyPartialUpdateNeeded(component)) {
            this.renderAjaxChildren(context, component);
        } else {
            super.encodeChildren(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIScrollableDataTable) {
            UIScrollableDataTable grid = (UIScrollableDataTable)component;
            this.setUpState(context, grid);
        }
        if (!this.onlyPartialUpdateNeeded(component)) {
            super.encodeBegin(context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIScrollableDataTable && !this.onlyPartialUpdateNeeded(component)) {
            super.encodeEnd(context, component);
        }
    }

    public void setUpColumnsWidth(FacesContext context, UIScrollableDataTable grid) throws IOException {
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
        ColumnWalker.iterateOverColumns(context, (UIComponent)grid, this.columnsWidthCounter, null, state);
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)grid);
        int sumWidth = state.getSumWidth() + 200;
        variables.setVariable("sumWidth", (Object)new Integer(sumWidth));
    }

    private RendererBase getCellTemplate() {
        if (this.cellTemplate == null) {
            this.cellTemplate = TemplateLoader.loadTemplate("org.richfaces.renderkit.html.ScrollableDataTableCellRenderer");
        }
        return this.cellTemplate;
    }

    private RendererBase getHeaderCellTemplate() {
        if (this.headerCellTemplate == null) {
            this.headerCellTemplate = TemplateLoader.loadTemplate("org.richfaces.renderkit.html.ScrollableDataTableHeaderCellRenderer");
        }
        return this.headerCellTemplate;
    }

    private RendererBase getFooterCellTemplate() {
        if (this.footerCellTemplate == null) {
            this.footerCellTemplate = TemplateLoader.loadTemplate("org.richfaces.renderkit.html.ScrollableDataTableFooterCellRenderer");
        }
        return this.footerCellTemplate;
    }

    private RendererBase getHeaderItselfTemplate() {
        if (this.headerItselfTemplate == null) {
            this.headerItselfTemplate = TemplateLoader.loadTemplate("org.richfaces.renderkit.html.ScrollableDataTableHeaderItselfRenderer");
        }
        return this.headerItselfTemplate;
    }

    public void renderHiddenScrollInput(FacesContext context, UIScrollableDataTable grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = grid.getClientId(context) + ":si";
        writer.startElement("input", (UIComponent)grid);
        this.getUtils().writeAttribute(writer, "type", (Object)"hidden");
        this.getUtils().writeAttribute(writer, "name", (Object)id);
        this.getUtils().writeAttribute(writer, "id", (Object)id);
        this.getUtils().writeAttribute(writer, "value", (Object)grid.getScrollPos());
        writer.endElement("input");
    }

    public void contributorsEncodeHere(FacesContext context, UIScrollableDataTable grid) throws IOException {
        RendererContributor[] contribs = this.getContributors();
        if (contribs != null) {
            for (int i = 0; i < contribs.length; ++i) {
                RendererContributor rendererContributor = contribs[i];
                if (!(rendererContributor instanceof HTMLEncodingContributor)) continue;
                ((HTMLEncodingContributor)rendererContributor).encode(context, (UIComponent)grid);
            }
        }
    }

    private void addRowJavascriptEvents(ResponseWriter writer, UIComponent component) {
        String attribute = (String)component.getAttributes().get("onRowClick");
        if (attribute != null) {
            try {
                this.getUtils().writeAttribute(writer, "onclick", (Object)attribute);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((attribute = (String)component.getAttributes().get("onRowMouseDown")) != null) {
            try {
                this.getUtils().writeAttribute(writer, "onmousedown", (Object)attribute);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((attribute = (String)component.getAttributes().get("onRowMouseUp")) != null) {
            try {
                this.getUtils().writeAttribute(writer, "onmouseup", (Object)attribute);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((attribute = (String)component.getAttributes().get("onRowDblClick")) != null) {
            try {
                this.getUtils().writeAttribute(writer, "ondblclick", (Object)attribute);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Boolean getColumnSorting(UIScrollableDataTable grid, int columnIndex) {
        SortField[] sortFields;
        Boolean sorting = null;
        Column column = (Column)grid.getChildren().get(columnIndex);
        String name = ColumnUtil.getColumnSorting((Column)column);
        SortOrder sortOrder = grid.getSortOrder();
        if (sortOrder != null && (sortFields = sortOrder.getFields()) != null) {
            for (int i = 0; i < sortFields.length && sorting == null; ++i) {
                SortField sortField = sortFields[i];
                if ((name == null || !name.equals(sortField.getName())) && columnIndex != sortField.getIndex()) continue;
                sorting = sortField.getAscending();
            }
        }
        return sorting;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

