package org.richfaces.component;

import java.io.IOException;

import javax.faces.component.UIMessage;
import javax.faces.context.FacesContext;

import org.ajax4jsf.component.AjaxOutput;


/**
 * @author Anton Belevich
 *
 */
public abstract class UIRichMessage extends UIMessage implements AjaxOutput{
	
	private boolean isPassed = false;
		
	public boolean isPassed() {
		return isPassed;
	}
	
	public abstract String getPassedLabel();
	
	public abstract void setPassedLabel(String passedLabel);
	
	public boolean isAjaxRendered() {
		return true;
	}
	
	public void setAjaxRendered(boolean ajaxRendered) {
		if(!ajaxRendered){
			new IllegalArgumentException();
		}	
	}
	
	public void decode(FacesContext context) {
		isPassed = true;
		super.decode(context);
	}
	
	public void encodeBagin(FacesContext context) throws IOException {
		isPassed = true;
		super.encodeBegin(context);
	}

	public void encodeEnd(FacesContext context) throws IOException {
		super.encodeEnd(context);
		isPassed = false;
	}
	
	public abstract String getLevel();

	public abstract void setLevel(String level);

	
}