/**
 * 
 */
package org.richfaces.renderkit.html;

import javax.faces.context.FacesContext;

import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.UIScrollableDataTable;


public class AjaxFunctionBuilder {

	private static final JSReference request = new JSReference("request");
	private static final JSReference event = new JSReference("event");
	private static final JSReference data = new JSReference("data");
	public static final int SORT = 0;
	public static final int SCROLL = 1;
	
	public static JSFunction createFunction(String name) {
		JSFunction function = new JSFunction(name);
		function.addParameter(request);
		function.addParameter(event);
		function.addParameter(data);
		
		return function;
	}	
		
	public static JSFunctionDefinition getOnComplete(FacesContext context, UIScrollableDataTable grid, int type) {
		
		JSFunction function = null;
		
		switch (type) {
			case SCROLL:
				function = createFunction(ScrollableDataTableBaseRenderer.getJavaScriptVarName(context, grid) + ".onScrollComplete");
				break;
			case SORT: 				
				function = createFunction(ScrollableDataTableBaseRenderer.getJavaScriptVarName(context, grid) + ".onSortComplete");
				break;
		}	

		JSFunctionDefinition functionDefinition = new JSFunctionDefinition();
		functionDefinition.addToBody(function);
		functionDefinition.addParameter(request);
		functionDefinition.addParameter(event);
		functionDefinition.addParameter(data);
		
		return functionDefinition;
	}
}