/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.taglib;

import javax.faces.context.FacesContext;

import org.ajax4jsf.webapp.taglib.HtmlComponentTagBase;

public abstract class SimpleTogglePanelTagBase extends HtmlComponentTagBase {

	private boolean _openedSet = false;
	private String _value = null;

	private void logValueDeprecation(String value) {
		FacesContext facesContext = getFacesContext();
		facesContext.getExternalContext().log("opened attribute has been already set for component with id: " + this.getId() + 
				"[" + this._value + "]. value attribute is deprecated and thus has been dropped!");
	}
	
	public void setOpened(String opened) {
		if (_value != null) {
			logValueDeprecation(_value);
		}
		
		_openedSet = false;
		super.setValue(opened);
		_openedSet = true;
	}
	
	public void setValue(String value) {
		if (!_openedSet) {
			_value = value;
			super.setValue(value);
		} else {
			logValueDeprecation(value);
		}
	}

	public void release() {
		super.release();
		_openedSet = false;
		_value = null;
	}
	
}
