/**
 * 
 */
package org.richfaces.renderkit.html.iconimages;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

import org.ajax4jsf.resource.ResourceContext;

/**
 * @author Anton Belevich
 *
 */
public abstract class PanelMenuIconTriangleBasic extends PanelMenuIconBasic {

	protected void paintImage(ResourceContext context, Graphics2D g2d, Color color) {
		
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
		g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
		
		GeneralPath path = new GeneralPath();

		Dimension  dimension = getDimensions(context);
		g2d.scale(dimension.getHeight()/128,dimension.getHeight()/128);
		
		draw(path, g2d);
		
		g2d.setColor(color);
		g2d.fill(path);

	}
	
	abstract void draw(GeneralPath path, Graphics2D g2d);  

}
