// $ANTLR 2.7.6 (2005-12-22): "html-seamtext.g" -> "HtmlSeamTextParser.java"$

	package org.richfaces.antlr;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
	
	import org.jboss.seam.text.SeamTextParser.DefaultSanitizer;
	import org.jboss.seam.text.SeamTextParser.Sanitizer; 

public class HtmlSeamTextParser extends antlr.LLkParser       implements HtmlSeamTextParserTokenTypes
 {
	 
	
	
	public class HtmlRecognitionException extends RecognitionException {
		Token openingElement;
		RecognitionException wrappedException;

		public HtmlRecognitionException(Token openingElement, RecognitionException wrappedException) {
			this.openingElement = openingElement;
			this.wrappedException = wrappedException;
		}

		public Token getOpeningElement() {
			return openingElement;
		}

		public String getMessage() {
			return wrappedException.getMessage();
		}

		public Throwable getCause() {
			return wrappedException;
		}
	}
	
	    
    private final String  SEAMTEXT_MONOSPACE = "|";
    
    private final String  SEAMTEXT_TWIDDLE = "~";
    
    private final String  SEAMTEXT_HASH = "#";
    
    private final String  SEAMTEXT_HAT = "^";
    
    private final String  SEAMTEXT_PLUS = "+";
    
    private final String  SEAMTEXT_STAR = "*";
    
    private final String  SEAMTEXT_UNDERSCORE = "_";
    
    private final String  SEAMTEXT_EQ = "=";
    
    private final String  SEAMTEXT_BACKTICK = "`";
    
    private final String  BLANK_LINE = "\n\n";
    
    private final String  SEAM_DOUBLEQUOTE = "\"";
    
    private final String  SEAM_OPEN = "[";
    
    private final String  SEAM_CLOSE = "]";
    
    private final String  SEAM_GT = ">";
    
    public boolean preformatted = false;
    
    protected java.util.Set<String> seamTextSymbols = 	new java.util.HashSet(java.util.Arrays.asList(
		SEAMTEXT_MONOSPACE, SEAMTEXT_TWIDDLE, SEAMTEXT_HASH, SEAMTEXT_HAT, SEAMTEXT_PLUS, SEAMTEXT_STAR, 
		SEAMTEXT_UNDERSCORE, SEAMTEXT_EQ, SEAMTEXT_BACKTICK, BLANK_LINE, SEAM_DOUBLEQUOTE, SEAM_OPEN,
		SEAM_CLOSE, SEAM_GT 
	));
            
   	protected java.util.Set<String> htmlSeamTextElements = new java.util.HashSet(java.util.Arrays.asList(
		"del", "sup", "pre","p", "q" ,"h1" ,"h2" ,"h3" ,"h4" ,"ul" ,"ol" ,"li" ,"i" ,"tt" ,"u" ,"a","blockqoute"));
		
	protected java.util.Set<String> simpleHtmlSeamTextElements = new java.util.HashSet(java.util.Arrays.asList(
		"del", "sup", "pre", "q", "i" ,"tt" ,"u"));	
		
	protected 	java.util.Set<String> formattedHtmlSeamTextElements = new java.util.HashSet(java.util.Arrays.asList(
		"ul", "ol", "li", "h1", "h2", "h3", "h4", "a", "p", "blockqoute"));
		
	private Sanitizer sanitizer = new DefaultSanitizer();
	
	private java.util.Stack<Token> htmlElementStack = new java.util.Stack<Token>();
	
	private StringBuilder mainBuilder = new StringBuilder();
	
	private String linkHolder;
	
	private int newlines;
	
	private boolean isHeaderProcessed = false;
	
	private StringBuilder builder = mainBuilder;
	
	public StringBuilder valueCollector;
	
	
	public void setSanitizer(Sanitizer sanitizer) {
       this.sanitizer = sanitizer;
    }
	
	
	public String toString() {
        return builder.toString();
    }
	
	
	private void beginCapture() {
        builder = new StringBuilder();
    }
    
    
    private String endCapture() {
        String result = builder.toString();
        builder = mainBuilder;
        return result;
    }
	
	
	private void append(String... strings) {
        for (String string: strings) builder.append(string);
    }
    
   	    
   	public boolean isLink(Token token) {
   		String name = token.getText().toLowerCase();
   		return "a".equals(name);
   	}
   	 
   	   	
   	private String createSeamTextLink(String link, String value) {
   		
   		StringBuilder builder = new StringBuilder();
   		builder.append("[");
   		
   		if (value != null) {
   			builder.append(value.trim());
   		} 
   		   		  		
   		builder.append("=>");
   		builder.append(link);
   		builder.append("]");
   		
   		return builder.toString();
   		
   	}
   	
   	
   	public boolean isHeader(Token token) {
   		String name = token.getText().toLowerCase();
   		return ("h1".equals(name) || "h2".equals(name) || "h3".equals(name) || "h4".equals(name));  
   	}
   	
   	   	
   	public String createSeamTextHeader(Token token) throws SemanticException {
   		
   		String name = token.getText();
   		StringBuilder seamHeader = new StringBuilder(); 
 		
		if("h1".equals(name)) {
			seamHeader.append(BLANK_LINE).append(SEAMTEXT_PLUS);
   		} else if("h2".equals(name)) {
   			seamHeader.append(BLANK_LINE).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS);
   		} else if("h3".equals(name)) {
   			seamHeader.append(BLANK_LINE).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS);
   		} else if("h4".equals(name)) {
   			seamHeader.append(BLANK_LINE).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS).append(SEAMTEXT_PLUS);
   		}
   		
   		return seamHeader.toString();
   	}
   	
   	public boolean isParagraph(Token token) {
		String name = token.getText().toLowerCase();
   		return "p".equals(name) ;  
	}
	
   	public String checkHeaderMarkup() throws TokenStreamException{
   		
   		int i = 0;
   		StringBuilder result = new StringBuilder();
   		Token  token;
   	
   		boolean containText = false; 
   	 	
	   	do {
			i++;
			token = LT(i);
			if (token.getType() == ALPHANUMERICWORD) {
			
				if (!isHeader(token)) {
					result.append("\n");
					containText = true;
				}   
				
				break;
			}
			   			   	 			
		} while ( token.getType() != EOF);
		
								
		if (!containText) {
			result.append("\n").append("<span></span>");
		} 
		return result.toString();
	}
	
	
		
		
	public String checkParagraphMarkup() throws TokenStreamException{
		int i = 0;
		Token token;
		do {
			i++;
			token = LT(i);
			if (token.getType() == ALPHANUMERICWORD) {
				if(!(isParagraph(token) || isHeader(token) || isList(token))) {
					return BLANK_LINE;
				}  
				break ;
			}	
			
		}while(token.getType() != EOF);
		return "";	
	}
   	
   	public String checkListMarkup() throws TokenStreamException {
  		int i = 0;
		Token token;
		do {
			i++;
			token = LT(i);
			if (token.getType() == ALPHANUMERICWORD) {
				if(!(isParagraph(token) || isHeader(token))) {
					return BLANK_LINE;
				}
				break;	
			
			}	
			
		}while(token.getType() != EOF);
		return "";
  	  		 		
   	}
   	
   	public String checkListItemMarkup() throws TokenStreamException {
   		int i = 0;
		Token token;
		do {
			i++;
			token = LT(i);
			if (token.getType() == ALPHANUMERICWORD) {
				if(isList(token)) {
					return "";
				} else if(isListItem(token)) {
					return "\n";
				}
				break;	
			}	
			
		}while(token.getType() != EOF);
		return "";
   	}
   	
   	public boolean isList(Token token){
    	String name = token.getText();
    	return ("ul".equals(name) || "ol".equals(name));
    }
    
   	  	
   	public boolean isListItem(Token token) {
   		String name = token.getText().toLowerCase();
   		return "li".equals(name);
   	}
   	
   	  	
   	public String createSeamTextList(Token token, java.util.Stack <Token> htmlElementStack) throws SemanticException {
		String seamText = null;
   		
   		Token parent = htmlElementStack.peek();
   		String parentName = parent.getText().toLowerCase();
		if(parentName.equals("ul")) {
			seamText = SEAMTEXT_EQ;
		} else if (parentName.equals("ol")){
			seamText = SEAMTEXT_HASH;
		} else {
			String message = "<li> must follow <ol> or <ul> not <" + parent.getText() + ">";
			throw new SemanticException( message, parent.getFilename(), parent.getLine(), parent.getColumn());
		}
   		
   		return seamText != null ? seamText : "";
   	}
   	
   	
   	public boolean isPlainHtmlRequired(Token name, java.util.Stack <Token> htmlElementStack) throws SemanticException {

   		if(!isSeamTextElement(name)) {
   			return true;
   		}
   		
   		if(isSimpleSeamTextElement(name)) {
   			return false;
   		}
   		
   		if(isHeader(name) && !htmlElementStack.isEmpty()) {
   			return true;
   		}
   		   		   		  		   		
   		if(!htmlElementStack.isEmpty() && !"a".equals(name.getText().toLowerCase()) && !"p".equals(name.getText().toLowerCase())) {
			for(Token token : htmlElementStack) {
				if(isHeader(token) || isListItem(token)) {
					return true;
				}
			}
		}
   		   		
   		return false;
   	}
    
     
   	
   	public String getSimpleSeamText(Token token) throws SemanticException,TokenStreamException{
    
    	String name = token.getText().toLowerCase();
		StringBuilder seamText = new StringBuilder();
	
		if("tt".equals(name)) {
			seamText.append(SEAMTEXT_MONOSPACE); 
		} else if("del".equals(name)) {
			seamText.append(SEAMTEXT_TWIDDLE);
		} else if("i".equals(name)) {
			seamText.append(SEAMTEXT_STAR); 
		} else if("sup".equals(name)) {
			seamText.append(SEAMTEXT_HAT); 
		} else if("u".equals(name)) {
			seamText.append(SEAMTEXT_UNDERSCORE);
		} else if("pre".equals(name)) {
			seamText.append(SEAMTEXT_BACKTICK);	
		} else if("q".equals(name)) {
			seamText.append(SEAM_DOUBLEQUOTE);
		} 						
		return seamText.toString();
	  	
    }
    
    
	public String escapeSeamText(Token token,  boolean preformatted) throws TokenStreamException {
   		
   		StringBuilder result = new StringBuilder();
		String tokenName = token.getText();
		
		if(preformatted) {
			if ("&lt;".equals(tokenName)) {
				result.append("<");
			} else if("&amp;".equals(tokenName)) {
				result.append("&");
			} else if ("&gt;".equals(tokenName)) {
				result.append(">");
			} else if("&quot;".equals(tokenName)){
				result.append("\"");
			} else if(seamTextSymbols.contains(tokenName)) {
				result.append(tokenName);
			}
				
		} else {
		
			if ("&lt;".equals(tokenName)) {
				result.append("\\<");
			} else if("&amp;".equals(tokenName)) {
				result.append("&");
			} else if ("&gt;".equals(tokenName)) {
				result.append("\\>");
			} else if("&quot;".equals(tokenName)){
				result.append("\"");
			} else if("\\".equals(tokenName)){
				result.append("\\\\");
			}else if(seamTextSymbols.contains(tokenName)) {
				result.append("\\").append(tokenName);
			}
		} 
		  		
   	 	return result.toString();	
	}
	    
        
    public boolean isSeamTextElement(Token element){
		String name = element.getText().toLowerCase();
		return htmlSeamTextElements.contains(name);
    }
	
	    
    public boolean isSimpleSeamTextElement(Token element){
		String name = element.getText().toLowerCase();
		return simpleHtmlSeamTextElements.contains(name);
    }
    
    
    public boolean isFormattedHtmlSeamTextElement(Token element) {
    	String name = element.getText().toLowerCase();
		return formattedHtmlSeamTextElements.contains(name);
    }
    
    
    public boolean isPreFormattedElement(Token element) {
    	String name = element.getText().toLowerCase();
    	return ("pre".equals(name) || "tt".equals(name));
    }
    

protected HtmlSeamTextParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public HtmlSeamTextParser(TokenBuffer tokenBuf) {
  this(tokenBuf,4);
}

protected HtmlSeamTextParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public HtmlSeamTextParser(TokenStream lexer) {
  this(lexer,4);
}

public HtmlSeamTextParser(ParserSharedInputState state) {
  super(state,4);
  tokenNames = _tokenNames;
}

	public final void startRule() throws RecognitionException, TokenStreamException {
		
		
		{
		_loop3:
		do {
			if ((LA(1)==NEWLINE)) {
				match(NEWLINE);
			}
			else {
				break _loop3;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case SPACE:
		case ALPHANUMERICWORD:
		case UNICODEWORD:
		case DOUBLEQUOTE:
		case ESCAPED_LT:
		case ESCAPED_GT:
		case ESCAPED_AMP:
		case ESCAPED_QOUT:
		case ESCAPED_NBSP:
		case PUNCTUATION:
		case SINGLEQUOTE:
		case SLASH:
		case STAR:
		case BAR:
		case HAT:
		case PLUS:
		case EQ:
		case HASH:
		case ESCAPE:
		case TWIDDLE:
		case OPEN:
		case CLOSE:
		case BACKTICK:
		case GT:
		case LT:
		{
			text();
			eof();
			break;
		}
		case EOF:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void text() throws RecognitionException, TokenStreamException {
		
		
		{
		int _cnt10=0;
		_loop10:
		do {
			if ((_tokenSet_0.member(LA(1)))) {
				{
				switch ( LA(1)) {
				case STAR:
				case BAR:
				case HAT:
				case PLUS:
				case EQ:
				case HASH:
				case ESCAPE:
				case TWIDDLE:
				case OPEN:
				case CLOSE:
				case BACKTICK:
				case GT:
				{
					seamCharacters();
					break;
				}
				case SPACE:
				case ALPHANUMERICWORD:
				case UNICODEWORD:
				case PUNCTUATION:
				case SINGLEQUOTE:
				case SLASH:
				{
					plain();
					break;
				}
				case LT:
				{
					html();
					break;
				}
				case DOUBLEQUOTE:
				case ESCAPED_LT:
				case ESCAPED_GT:
				case ESCAPED_AMP:
				case ESCAPED_QOUT:
				case ESCAPED_NBSP:
				{
					htmlSpecialChars();
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				{
				_loop9:
				do {
					if ((LA(1)==NEWLINE)) {
						match(NEWLINE);
						
								Token token = LT(2);
								if(!isParagraph(token) && isHeaderProcessed) {
									isHeaderProcessed = false;
								} 
						
							
					}
					else {
						break _loop9;
					}
					
				} while (true);
				}
			}
			else {
				if ( _cnt10>=1 ) { break _loop10; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt10++;
		} while (true);
		}
	}
	
	public final void eof() throws RecognitionException, TokenStreamException {
		
		
		match(Token.EOF_TYPE);
	}
	
	public final void seamCharacters() throws RecognitionException, TokenStreamException {
		
		Token  hat = null;
		Token  hash = null;
		Token  open = null;
		Token  close = null;
		Token  twiddle = null;
		Token  bar = null;
		Token  eq = null;
		Token  plus = null;
		Token  backtick = null;
		Token  st = null;
		Token  e = null;
		Token  gt = null;
		
		switch ( LA(1)) {
		case HAT:
		{
			hat = LT(1);
			match(HAT);
			append(escapeSeamText(hat, preformatted));
			break;
		}
		case HASH:
		{
			hash = LT(1);
			match(HASH);
			append(escapeSeamText(hash, preformatted));
			break;
		}
		case OPEN:
		{
			open = LT(1);
			match(OPEN);
			append(escapeSeamText(open, preformatted)) ;
			break;
		}
		case CLOSE:
		{
			close = LT(1);
			match(CLOSE);
			append(escapeSeamText(close, preformatted));
			break;
		}
		case TWIDDLE:
		{
			twiddle = LT(1);
			match(TWIDDLE);
			append(escapeSeamText(twiddle, preformatted));
			break;
		}
		case BAR:
		{
			bar = LT(1);
			match(BAR);
			append(escapeSeamText(bar, preformatted));
			break;
		}
		case EQ:
		{
			eq = LT(1);
			match(EQ);
			append(escapeSeamText(eq, preformatted));
			break;
		}
		case PLUS:
		{
			plus = LT(1);
			match(PLUS);
			append(escapeSeamText(plus, preformatted));
			break;
		}
		case BACKTICK:
		{
			backtick = LT(1);
			match(BACKTICK);
			append(escapeSeamText(backtick, preformatted));
			break;
		}
		case STAR:
		{
			st = LT(1);
			match(STAR);
			append(escapeSeamText(st, preformatted));
			break;
		}
		case ESCAPE:
		{
			e = LT(1);
			match(ESCAPE);
			append(escapeSeamText(e, preformatted));
			break;
		}
		case GT:
		{
			gt = LT(1);
			match(GT);
			append(escapeSeamText(gt, preformatted));
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void plain() throws RecognitionException, TokenStreamException {
		
		Token  space = null;
		
		{
		switch ( LA(1)) {
		case ALPHANUMERICWORD:
		case UNICODEWORD:
		{
			word();
			break;
		}
		case PUNCTUATION:
		case SINGLEQUOTE:
		case SLASH:
		{
			punctuation();
			break;
		}
		case SPACE:
		{
			space = LT(1);
			match(SPACE);
			
				 	append(space.getText());
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
			
				Token token = LT(2);
				if(!isParagraph(token) && isHeaderProcessed) {
					isHeaderProcessed = false;
				} 		
			
	}
	
	public final void html() throws RecognitionException, TokenStreamException {
		
		
		openTag();
		{
		_loop24:
		do {
			if ((LA(1)==SPACE) && (LA(2)==SPACE||LA(2)==SLASH||LA(2)==GT)) {
				space();
			}
			else if ((LA(1)==SPACE) && (LA(2)==ALPHANUMERICWORD)) {
				space();
				attribute();
			}
			else {
				break _loop24;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case GT:
		{
			{
			beforeBody();
			body();
			closeTagWithBody();
			}
			break;
		}
		case SLASH:
		{
			closeTagWithNoBody();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void htmlSpecialChars() throws RecognitionException, TokenStreamException {
		
		Token  lt = null;
		Token  gt = null;
		Token  amp = null;
		Token  qout = null;
		Token  nbsp = null;
		
		switch ( LA(1)) {
		case DOUBLEQUOTE:
		{
			match(DOUBLEQUOTE);
			append("\"");
			break;
		}
		case ESCAPED_LT:
		{
			lt = LT(1);
			match(ESCAPED_LT);
			append(escapeSeamText(lt, preformatted));
			break;
		}
		case ESCAPED_GT:
		{
			gt = LT(1);
			match(ESCAPED_GT);
			append(escapeSeamText(gt, preformatted));
			break;
		}
		case ESCAPED_AMP:
		{
			amp = LT(1);
			match(ESCAPED_AMP);
			append(escapeSeamText(amp, preformatted));
			break;
		}
		case ESCAPED_QOUT:
		{
			qout = LT(1);
			match(ESCAPED_QOUT);
			append(escapeSeamText(qout, preformatted));
			break;
		}
		case ESCAPED_NBSP:
		{
			nbsp = LT(1);
			match(ESCAPED_NBSP);
			append(" ");
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void word() throws RecognitionException, TokenStreamException {
		
		Token  an = null;
		Token  uc = null;
		
		switch ( LA(1)) {
		case ALPHANUMERICWORD:
		{
			an = LT(1);
			match(ALPHANUMERICWORD);
			append( an.getText() );
			break;
		}
		case UNICODEWORD:
		{
			uc = LT(1);
			match(UNICODEWORD);
			append( uc.getText() );
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void punctuation() throws RecognitionException, TokenStreamException {
		
		Token  p = null;
		Token  sq = null;
		Token  s = null;
		
		switch ( LA(1)) {
		case PUNCTUATION:
		{
			p = LT(1);
			match(PUNCTUATION);
			append( p.getText() );
			break;
		}
		case SINGLEQUOTE:
		{
			sq = LT(1);
			match(SINGLEQUOTE);
			append( sq.getText() );
			break;
		}
		case SLASH:
		{
			s = LT(1);
			match(SLASH);
			append( s.getText() );
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void specialChars() throws RecognitionException, TokenStreamException {
		
		Token  st = null;
		Token  b = null;
		Token  h = null;
		Token  p = null;
		Token  eq = null;
		Token  hh = null;
		Token  e = null;
		Token  t = null;
		Token  u = null;
		
		switch ( LA(1)) {
		case STAR:
		{
			st = LT(1);
			match(STAR);
			append( st.getText() );
			break;
		}
		case BAR:
		{
			b = LT(1);
			match(BAR);
			append( b.getText() );
			break;
		}
		case HAT:
		{
			h = LT(1);
			match(HAT);
			append( h.getText() );
			break;
		}
		case PLUS:
		{
			p = LT(1);
			match(PLUS);
			append( p.getText() );
			break;
		}
		case EQ:
		{
			eq = LT(1);
			match(EQ);
			append( eq.getText() );
			break;
		}
		case HASH:
		{
			hh = LT(1);
			match(HASH);
			append( hh.getText() );
			break;
		}
		case ESCAPE:
		{
			e = LT(1);
			match(ESCAPE);
			append( e.getText() );
			break;
		}
		case TWIDDLE:
		{
			t = LT(1);
			match(TWIDDLE);
			append( t.getText() );
			break;
		}
		case UNDERSCORE:
		{
			u = LT(1);
			match(UNDERSCORE);
			append( u.getText() );
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void space() throws RecognitionException, TokenStreamException {
		
		Token  s = null;
		
		s = LT(1);
		match(SPACE);
		
				if(!htmlElementStack.isEmpty()) {
					Token token = htmlElementStack.pop();
					if(isPlainHtmlRequired(token, htmlElementStack)) {
						append(s.getText());
					} 
					htmlElementStack.push(token);	
				} 
			
	}
	
	public final void newline() throws RecognitionException, TokenStreamException {
		
		Token  n = null;
		
		n = LT(1);
		match(NEWLINE);
		if (preformatted && valueCollector!=null) valueCollector.append(n.getText());
	}
	
	public final void newlineOrEof() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case NEWLINE:
		{
			newline();
			break;
		}
		case EOF:
		{
			match(Token.EOF_TYPE);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void openTag() throws RecognitionException, TokenStreamException {
		
		Token  name = null;
		
		try {      // for error handling
			match(LT);
			name = LT(1);
			match(ALPHANUMERICWORD);
			
			sanitizer.validateHtmlElement(name);
			
			Token token = null;
			
			if(isPreFormattedElement(name)) {
				preformatted = true;
			} 
			
			if(!isPlainHtmlRequired(name, htmlElementStack)) {
				
				if (isFormattedHtmlSeamTextElement(name)) {
					
					if(isLink(name) && valueCollector != null) {
						append(valueCollector.toString());
						valueCollector = null; 
					}if(isList(name)) {
						append(BLANK_LINE);
					} else if (isListItem(name)) {
						append(createSeamTextList(name, htmlElementStack));
				         	} else if (isHeader(name)) {
				         		append(createSeamTextHeader(name));
				         	}else if(isParagraph(name) && !isHeaderProcessed) {
				         		if(!isHeaderProcessed) {
				         			append(BLANK_LINE);
				         		}
				         	} 
				         	
				} else if(isSimpleSeamTextElement(name)) {
					if(valueCollector != null) {
								append(valueCollector.toString());
								valueCollector = null;
							} 
					append(getSimpleSeamText(name));
				}	
				
			} else {
				         	
				if(valueCollector != null) {
					append(valueCollector.toString());
					valueCollector = null;
						}
						append("<");
						append(name.getText());
			}
						
			htmlElementStack.push(name);
			
			
		}
		catch (RecognitionException ex) {
			
			if (htmlElementStack.isEmpty()) throw ex;
			Token tok = htmlElementStack.peek();
			if (tok != null) {
			throw new HtmlRecognitionException(tok, ex);
			} else {
			throw ex;
			}
			
		}
	}
	
	public final void attribute() throws RecognitionException, TokenStreamException {
		
		Token  att = null;
		
		try {      // for error handling
			att = LT(1);
			match(ALPHANUMERICWORD);
			{
			_loop38:
			do {
				if ((LA(1)==SPACE)) {
					space();
				}
				else {
					break _loop38;
				}
				
			} while (true);
			}
			match(EQ);
			{
			_loop40:
			do {
				if ((LA(1)==SPACE)) {
					space();
				}
				else {
					break _loop40;
				}
				
			} while (true);
			}
			match(DOUBLEQUOTE);
			
				   Token token = htmlElementStack.pop(); 	 
			sanitizer.validateHtmlAttribute(token, att);
			//               boolean isSeamTextProcessed = isSeamTextElement(token);
			boolean isPlainHtmlRequired = isPlainHtmlRequired(token, htmlElementStack);
			
			if (isPlainHtmlRequired) {
				   		append(att.getText());
				   		append("=\"");
			}
			beginCapture(); 
			
			attributeValue();
			
				   String attValue = endCapture();
						   sanitizer.validateHtmlAttributeValue(token, att, attValue);
			
			if (isPlainHtmlRequired) {
					append(attValue);
			} else if(isLink(token) && "href".equals(att.getText())) {
					
					linkHolder = attValue;               	
			}
			
			
			match(DOUBLEQUOTE);
			
				           	if(isPlainHtmlRequired) {
				           		append("\"");
				           	}
				           	htmlElementStack.push(token);
				
		}
		catch (RecognitionException ex) {
			
			if (htmlElementStack.isEmpty()) throw ex;
			Token tok = htmlElementStack.peek();
			if (tok != null) {
			throw new HtmlRecognitionException(tok, ex);
			} else {
			throw ex;
			}
			
		}
	}
	
	public final void beforeBody() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			match(GT);
			
					Token name = htmlElementStack.pop();
					if((isPlainHtmlRequired(name,htmlElementStack))) {
						append(">");
					} else {
						Token token = LT(1);
						if((isListItem(name) || isHeader(name)) && (token.getType() != SPACE)) {
							append(" ");
						}
					}
					htmlElementStack.push(name);
				
		}
		catch (RecognitionException ex) {
			
			if (htmlElementStack.isEmpty()) throw ex;
			Token tok = htmlElementStack.peek();
			if (tok != null) {
			throw new HtmlRecognitionException(tok, ex);
			} else {
			throw ex;
			}
			
		}
	}
	
	public final void body() throws RecognitionException, TokenStreamException {
		
		
		{
		{
		_loop31:
		do {
			switch ( LA(1)) {
			case SPACE:
			case ALPHANUMERICWORD:
			case UNICODEWORD:
			case DOUBLEQUOTE:
			case ESCAPED_LT:
			case ESCAPED_GT:
			case ESCAPED_AMP:
			case ESCAPED_QOUT:
			case ESCAPED_NBSP:
			case PUNCTUATION:
			case SINGLEQUOTE:
			case SLASH:
			case STAR:
			case BAR:
			case HAT:
			case PLUS:
			case EQ:
			case HASH:
			case ESCAPE:
			case TWIDDLE:
			case OPEN:
			case CLOSE:
			case BACKTICK:
			case GT:
			{
					
						beginCapture();
						Token token = htmlElementStack.peek();
					
				{
				switch ( LA(1)) {
				case STAR:
				case BAR:
				case HAT:
				case PLUS:
				case EQ:
				case HASH:
				case ESCAPE:
				case TWIDDLE:
				case OPEN:
				case CLOSE:
				case BACKTICK:
				case GT:
				{
					seamCharacters();
					break;
				}
				case SPACE:
				case ALPHANUMERICWORD:
				case UNICODEWORD:
				case PUNCTUATION:
				case SINGLEQUOTE:
				case SLASH:
				{
					plain();
					break;
				}
				case DOUBLEQUOTE:
				case ESCAPED_LT:
				case ESCAPED_GT:
				case ESCAPED_AMP:
				case ESCAPED_QOUT:
				case ESCAPED_NBSP:
				{
					htmlSpecialChars();
					
								if(isLink(token)) {
							 		String message = "Unexpected token " + "<" + token.getText() + ">";
									throw new SemanticException(message);
							 	}
							 		 	
							
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
					
					  	
					  	String plain = endCapture();
					 	if(valueCollector == null) {
					 		valueCollector = new StringBuilder();
					 	}
					 	if(!isList(token)) {
					 		
					 		valueCollector.append(plain);
					 	}
					 	
					
				break;
			}
			case NEWLINE:
			{
				newline();
				break;
			}
			default:
				if ((LA(1)==LT) && (LA(2)==ALPHANUMERICWORD)) {
					html();
					
						 		 		 	
						 	if(valueCollector != null) {
						 		append(valueCollector.toString());
						 	}
						 	
						 	
				}
			else {
				break _loop31;
			}
			}
		} while (true);
		}
		}
	}
	
	public final void closeTagWithBody() throws RecognitionException, TokenStreamException {
		
		Token  name = null;
		
		match(LT);
		match(SLASH);
		name = LT(1);
		match(ALPHANUMERICWORD);
		match(GT);
			
			 Token token = htmlElementStack.pop();
			 if(!token.getText().equals(name.getText())) {
			 	throw new RecognitionException("Can not convert to the Seam Text:  </" +token.getText() + ">" + " expected");
			 }
			 String value = "";
			 if(valueCollector != null) {
			 	value = valueCollector.toString();
			 }
			 
			 if(!isPlainHtmlRequired(name, htmlElementStack)) {
			 	if(isFormattedHtmlSeamTextElement(name)) {
			 	 	if(isLink(name)){
							append(createSeamTextLink(linkHolder,value.trim()));				
						} else if(isParagraph(name)) {
									append(value);
									if(isHeaderProcessed) {
			         					isHeaderProcessed = false;
			         				} 
			         				append(checkParagraphMarkup());
			         				
							
						} else {
							append(value);
						}
			      	 	
						if(isList(name)) {
							append(checkListMarkup());
						} else if(isListItem(name)) {
							append(checkListItemMarkup());
						} else if(isHeader(name)) {
							append(checkHeaderMarkup());
							isHeaderProcessed = true;
						} 
			         	
			 	} else if(isSimpleSeamTextElement(name)) {
			      	 	append(value.trim());
			  	 	append(getSimpleSeamText(name));
			 	}     	 
			 } else {
			 	append(value);
			 	append("</");
			append(name.getText());
			append(">");
			 }
			 
		valueCollector = null;
		
		if(isPreFormattedElement(name)) {
			preformatted = false;
		}
		
	}
	
	public final void closeTagWithNoBody() throws RecognitionException, TokenStreamException {
		
		
		match(SLASH);
		match(GT);
		append("/>");
		htmlElementStack.pop();
		
	}
	
	public final void attributeValue() throws RecognitionException, TokenStreamException {
		
		Token  an = null;
		Token  p = null;
		Token  s = null;
		Token  space = null;
		
		try {      // for error handling
			{
			_loop43:
			do {
				switch ( LA(1)) {
				case AMPERSAND:
				{
					match(AMPERSAND);
					append("&amp;");
					break;
				}
				case ALPHANUMERICWORD:
				{
					an = LT(1);
					match(ALPHANUMERICWORD);
					append( an.getText() );
					break;
				}
				case PUNCTUATION:
				{
					p = LT(1);
					match(PUNCTUATION);
					append( p.getText() );
					break;
				}
				case SLASH:
				{
					s = LT(1);
					match(SLASH);
					append( s.getText() );
					break;
				}
				case SPACE:
				{
					space = LT(1);
					match(SPACE);
					append(space.getText());
					break;
				}
				case STAR:
				case BAR:
				case HAT:
				case PLUS:
				case EQ:
				case HASH:
				case ESCAPE:
				case TWIDDLE:
				case UNDERSCORE:
				{
					specialChars();
					break;
				}
				default:
				{
					break _loop43;
				}
				}
			} while (true);
			}
		}
		catch (RecognitionException ex) {
			
			if (htmlElementStack.isEmpty()) throw ex;
			Token tok = htmlElementStack.peek();
			if (tok != null) {
			throw new HtmlRecognitionException(tok, ex);
			} else {
			throw ex;
			}
			
		}
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"the end of the text",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"a newline",
		"a space or tab",
		"letters or digits",
		"letters or digits",
		"a doublequote \\\"",
		"ESCAPED_LT",
		"ESCAPED_GT",
		"ESCAPED_AMP",
		"ESCAPED_QOUT",
		"ESCAPED_NBSP",
		"a punctuation character",
		"a single quote '",
		"a slash '/'",
		"a star '*'",
		"a bar or pipe '|'",
		"a caret '^'",
		"a plus '+'",
		"an equals '='",
		"a hash '#'",
		"the escaping blackslash '\\'",
		"a tilde '~'",
		"an underscore '_'",
		"an opening square bracket '['",
		"a closing square bracket ']'",
		"a backtick '`'",
		"a closing angle bracket '>'",
		"an opening angle bracket '<'",
		"an ampersand '&'"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 2113929184L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	
	}
