/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.json.JSONObject;
import org.richfaces.model.Ordering;

class ColumnGroupingState
implements Serializable {
    private static final long serialVersionUID = -3923409650272094713L;
    private static final Boolean DEF = Boolean.TRUE;
    private String columnId;
    private List<Boolean> groupExpanded;
    private Ordering ordering;

    private ColumnGroupingState() {
    }

    static ColumnGroupingState getColumnGropingState(UIExtendedDataTable extendedDataTable, JSONMap map) {
        ColumnGroupingState groupingState = new ColumnGroupingState();
        groupingState.init(extendedDataTable, map);
        return groupingState;
    }

    private void init(UIExtendedDataTable extendedDataTable, JSONMap map) {
        this.columnId = null;
        this.ordering = Ordering.UNSORTED;
        this.groupExpanded = new ArrayList<Boolean>();
        if (map != null && map.size() > 0) {
            this.columnId = (String)map.get((Object)"columnId");
            this.ordering = Ordering.valueOf((String)((String)map.get((Object)"order")));
        }
        if (this.columnId != null) {
            Iterator<UIColumn> columns = extendedDataTable.getChildColumns();
            while (columns.hasNext()) {
                UIColumn child = columns.next();
                if (!this.columnId.equalsIgnoreCase(child.getId())) continue;
                child.setSortOrder(this.ordering);
                break;
            }
        }
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        if (this.columnId != null) {
            try {
                result.put("columnId", (Object)this.columnId);
                result.put("order", (Object)this.ordering);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    String getGroupingColumnId() {
        return this.columnId;
    }

    void groupBy(String colId, Ordering ordering) {
        this.columnId = colId;
        this.ordering = ordering;
        this.resetGroupVisibilityState();
    }

    void resetGroupVisibilityState() {
        this.groupExpanded.clear();
    }

    void disableGrouping() {
        this.columnId = "none";
        this.ordering = Ordering.UNSORTED;
        this.resetGroupVisibilityState();
    }

    void toggleGroup(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index value :" + index);
        }
        if (index >= this.groupExpanded.size()) {
            int count = index - this.groupExpanded.size() + 1;
            for (int i = 0; i < count; ++i) {
                this.groupExpanded.add(DEF);
            }
        }
        this.groupExpanded.add(index, this.groupExpanded.remove(index) == false);
    }

    boolean groupIsExpanded(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index value :" + index);
        }
        if (index >= this.groupExpanded.size()) {
            return DEF;
        }
        return this.groupExpanded.get(index);
    }
}

