package org.ajax4jsf.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIInclude;

public class Include extends UIInclude{

final public static  String COMPONENT_FAMILY = "javax.faces.Output";

final public static  String COMPONENT_TYPE = "org.ajax4jsf.Include";

/*
* Direction indication for text that does not inherit
			directionality. Valid values are "LTR" (left-to-right)
			and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* Flag for mark all child components to non-transient. If
            true, all children components will be set to non-transient state
            and keep in saved components tree. For output in self-renderer
            region all content ( By default, all content in &amp;lt;f:verbatim&amp;gt;
            tags and non-jsf elements in facelets, marked as transient -
            since, self-rendered ajax regions don't plain output for ajax
            processing ).
*/
private  boolean _keepTransient = false;

private  boolean _keepTransientSet = false;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;


public Include(){
setRendererType("org.ajax4jsf.components.AjaxIncludeRenderer");
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public boolean isKeepTransient(){
	if (this._keepTransientSet) {
	    return (this._keepTransient);
	}
	ValueExpression ve = getValueExpression("keepTransient");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._keepTransient);
	    }
	    
	    return value;
	} else {
	    return (this._keepTransient);
	}

}

public void setKeepTransient(boolean _keepTransient){
this._keepTransient = _keepTransient;
this._keepTransientSet = true;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[8];
state[0] = super.saveState(context);
state[1] = _dir;
state[2] = Boolean.valueOf(_keepTransient);
state[3] = Boolean.valueOf(_keepTransientSet);
state[4] = _lang;
state[5] = _style;
state[6] = _styleClass;
state[7] = _title;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_dir = (String)states[1];;
		_keepTransient = ((Boolean)states[2]).booleanValue();
		_keepTransientSet = ((Boolean)states[3]).booleanValue();
		_lang = (String)states[4];;
		_style = (String)states[5];;
		_styleClass = (String)states[6];;
		_title = (String)states[7];;
	
}

}
