package org.ajax4jsf.component.html;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIPush;

public class AjaxPush extends UIPush{

final public static  String COMPONENT_FAMILY = "org.ajax4jsf.components.AjaxPush";

final public static  String COMPONENT_TYPE = "org.ajax4jsf.Push";

/*
* Limits JSF tree processing (decoding, conversion, validation and model updating) only to a component that sends the request. Boolean. Default value is "false".
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* If "true", after process validations phase it skips updates of model beans on a force render response. It can be used for validating components input
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* Serialized (on default with JSON) data passed on the client by a developer on AJAX request. It's accessible via "data.foo" syntax
*/
private  Object _data = null;

/*
* Enables/disables pushing. Default value is "true".
*/
private  boolean _enabled = true;

private  boolean _enabledSet = false;

/*
* MethodBinding pointing at method accepting  an PushEventListener with return type void.
            User bean must register this listener and send EventObject to this listener on ready.
*/
private  MethodExpression _eventProducer = null;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* ID of an element to set focus after request is completed on client side
*/
private  String _focus = null;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* Interval (in ms) for call push requests. Default value is "1000"ms (1 second).
*/
private  int _interval = Integer.MIN_VALUE;

private  boolean _intervalSet = false;

/*
* If "true", then of all AJAX-rendered on the page components only those will be updated, 
		which ID's are passed to the "reRender" attribute of the describable component. 
		"false"-the default value-means that all components with ajaxRendered="true" will be updated.
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* The client-side script method to be called before DOM is updated
*/
private  String _onbeforedomupdate = null;

/*
* The client-side script method to be called after the request is completed
*/
private  String _oncomplete = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, processed at the phases 2-5 in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _process = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* requestDelay
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* If there are any component requests with identical IDs then these requests will be grouped.
*/
private  String _similarityGroupingId = null;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* Timeout (in ms) for request
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;


public AjaxPush(){
setRendererType("org.ajax4jsf.components.AjaxPushRenderer");
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public boolean isEnabled(){
	if (this._enabledSet) {
	    return (this._enabled);
	}
	ValueExpression ve = getValueExpression("enabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._enabled);
	    }
	    
	    return value;
	} else {
	    return (this._enabled);
	}

}

public void setEnabled(boolean _enabled){
this._enabled = _enabled;
this._enabledSet = true;
}

public MethodExpression getEventProducer(){
return _eventProducer;
}

public void setEventProducer(MethodExpression _eventProducer){
this._eventProducer = _eventProducer;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public int getInterval(){
	if (this._intervalSet) {
	    return (this._interval);
	}
	ValueExpression ve = getValueExpression("interval");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._interval);
	    }
	    
	    return value;
	} else {
	    return (this._interval);
	}

}

public void setInterval(int _interval){
this._interval = _interval;
this._intervalSet = true;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public Object getProcess(){
	if (this._process != null) {
		return this._process;
	}
	ValueExpression ve = getValueExpression("process");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProcess(Object _process){
this._process = _process;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public String getSimilarityGroupingId(){
	if (this._similarityGroupingId != null) {
		return this._similarityGroupingId;
	}
	ValueExpression ve = getValueExpression("similarityGroupingId");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSimilarityGroupingId(String _similarityGroupingId){
this._similarityGroupingId = _similarityGroupingId;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[27];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_ajaxSingle);
state[2] = Boolean.valueOf(_ajaxSingleSet);
state[3] = Boolean.valueOf(_bypassUpdates);
state[4] = Boolean.valueOf(_bypassUpdatesSet);
state[5] = saveAttachedState(context, _data);
state[6] = Boolean.valueOf(_enabled);
state[7] = Boolean.valueOf(_enabledSet);
state[8] = saveAttachedState(context, _eventProducer);
state[9] = _eventsQueue;
state[10] = _focus;
state[11] = Boolean.valueOf(_ignoreDupResponses);
state[12] = Boolean.valueOf(_ignoreDupResponsesSet);
state[13] = Integer.valueOf(_interval);
state[14] = Boolean.valueOf(_intervalSet);
state[15] = Boolean.valueOf(_limitToList);
state[16] = Boolean.valueOf(_limitToListSet);
state[17] = _onbeforedomupdate;
state[18] = _oncomplete;
state[19] = saveAttachedState(context, _process);
state[20] = saveAttachedState(context, _reRender);
state[21] = Integer.valueOf(_requestDelay);
state[22] = Boolean.valueOf(_requestDelaySet);
state[23] = _similarityGroupingId;
state[24] = _status;
state[25] = Integer.valueOf(_timeout);
state[26] = Boolean.valueOf(_timeoutSet);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_ajaxSingle = ((Boolean)states[1]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[2]).booleanValue();
		_bypassUpdates = ((Boolean)states[3]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[4]).booleanValue();
		_data = (Object)restoreAttachedState(context, states[5]);
		_enabled = ((Boolean)states[6]).booleanValue();
		_enabledSet = ((Boolean)states[7]).booleanValue();
		_eventProducer = (MethodExpression)restoreAttachedState(context, states[8]);
		_eventsQueue = (String)states[9];;
		_focus = (String)states[10];;
		_ignoreDupResponses = ((Boolean)states[11]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[12]).booleanValue();
		_interval = ((Integer)states[13]).intValue();
		_intervalSet = ((Boolean)states[14]).booleanValue();
		_limitToList = ((Boolean)states[15]).booleanValue();
		_limitToListSet = ((Boolean)states[16]).booleanValue();
		_onbeforedomupdate = (String)states[17];;
		_oncomplete = (String)states[18];;
		_process = (Object)restoreAttachedState(context, states[19]);
		_reRender = (Object)restoreAttachedState(context, states[20]);
		_requestDelay = ((Integer)states[21]).intValue();
		_requestDelaySet = ((Boolean)states[22]).booleanValue();
		_similarityGroupingId = (String)states[23];;
		_status = (String)states[24];;
		_timeout = ((Integer)states[25]).intValue();
		_timeoutSet = ((Boolean)states[26]).booleanValue();
	
}

}
